
#include "sitypes.h"
#include "os_lnx.h"
#include "sierrors.h"

INT32 OS_Popup_MessageBox
(
    char *text,
    char *caption,
	UINT32 type
)
{
	FILE *fp;
	
	// if type == 0, then clear file before writing.
	if (type == 0)
		fp = fopen("/tmp/sisample.txt", "wt");
	else
		fp = fopen("/tmp/sisample.txt", "at");
		
	if (fp==NULL)
		return FALSE;
		
	fprintf(fp, "%s\n%s\n\n", caption, text);
	
	fclose(fp);

	return TRUE;
}


INT32 OS_CreateFile
(
	char *filename,
	UINT32 readWrite,
	UINT32 createExisting,
	void **ObjectPtr
)
{
	*ObjectPtr = NULL;
	
	if(createExisting)
		*ObjectPtr = (void *)fopen(filename, "w+");
	else
		*ObjectPtr = (void *)fopen(filename, "w");

	if(*ObjectPtr == NULL)
		return e_Err_CreateFile;

	return e_Err_NoError;
}

INT32 OS_ReadFile
(
	void			*fileHandle, 
	UINT32			*dataBuffer, 
	UINT32			numberOfBytesToRead, 
	UINT32			*bytesRead
)
{
	
	*bytesRead = fread(dataBuffer, sizeof(char),
	numberOfBytesToRead, (FILE
	*)fileHandle);
	
	if(*bytesRead == numberOfBytesToRead)
		return 1;
	else
		return 0;

}

INT32 OS_WriteFile
(
	void			*fileHandle, 
	UINT32			*dataBuffer, 
	UINT32			numberOfBytesToRead, 
	UINT32			*bytesRead
)
{
	
	*bytesRead = fwrite(dataBuffer, sizeof(char),
	numberOfBytesToRead, (FILE
	*)fileHandle);
	
	if(*bytesRead == numberOfBytesToRead)
		return 1;
	else
		return 0;

}

INT32 OS_CloseHandle
(
	void	*hObject
)
{
	return (fclose((FILE *)hObject));
}


INT32 OS_MessageBeep
(
	UINT32 Type
)
{
	if (MB_ICONHAND)
//		return (flash());
		return 0;
	else
		return (beep());
}

/*
Following functions were updated in Windows, it is necessary to update in Linux
Something is already created (2/15/07) but need test and troubleshoot.

///////////////////////////////////////////////////////////////////////////////
//
// Note: Following 4 functions are for displying messages in additional
//		windows created temporarily. OS_SHOW_WINDOW is not needed since
//		OS_Popup_CREATE_WINDOW already creates a visible window, but kept just
//		in case.
//
///////////////////////////////////////////////////////////////////////////////
//
//	inline INT32 OS_Popup_CREATE_WINDOW
//
//	Routine Description:
//		Creates a windows of 250 X 100, at position 100, 100 for messaging
//		purposes. These values are fixed for simplicity only, because by
//		the time We create this function, it was only one single message
//
//	Arguments:
//		void **newWindow: It returns the pointer (*newWindow) to the window
//			to be created. It is necessary to use doble pointer in order
//			to return a pointer.
//		char *caption: Pointer to string to be shown as Title of the new window
//
//	Return Value:
//		This is not a standard SI command and do not return error code,
//
//	Revision Notes:
//		2004-08-11:
//			Created by Ley.
//
*/

INT32 OS_Popup_CREATE_WINDOW
(
	void **newWindow,
	char *caption
)
{
// In Linux we don't pop-up a child window, instead
// we create a text file and show it as a message box.

	FILE *fp;

	fp = fopen("/tmp/sisample.txt", "wt");
	
	if (fp == NULL)
		return e_Err_CreateFile;
		
	fprintf(fp, "%s\n\n", caption);
	
	*newWindow = (void *)fp;

	return (INT32) (*newWindow);
}


///////////////////////////////////////////////////////////////////////////////
//
//	inline INT32 OS_Popup_SHOW_MESSAGE_ON_WINDOW
//
//	Routine Description:
//		Sends a message to a desired window for message-only purposes.
//
//	Arguments:
//		void *messageWindow: Pointer to the window where the message must
//			be shown.
//		char *message: Pointer to string to be shown as message
//
//	Return Value:
//		This is not a standard SI command and do not return error code,
//
//	Revision Notes:
//		2004-08-11:
//			Created by Ley.
//

INT32 OS_Popup_SHOW_MESSAGE_ON_WINDOW
(
	void *messageWindow,
	char *message
)
{
// In Linux we don't pop-up a child window, instead
// we create a text file and show it as a message box.

	fprintf((FILE *) messageWindow, "%s\n\n", message);

	return 0;
}


///////////////////////////////////////////////////////////////////////////////
//
//	inline INT32 OS_Popup_DESTROY_WINDOW
//
//	Routine Description:
//		Destroys a window created by OS_Popup_CREATE_WINDOW
//
//	Arguments:
//		void *windowToDestroy Pointer to window to be destroyed.
//
//	Return Value:
//		This is not a standard SI command and do not return error code,
//
//	Revision Notes:
//		2004-08-11:
//			Created by Ley.
//

INT32 OS_Popup_DESTROY_WINDOW
(
	void *windowToDestroy
)
{
// In Linux we don't pop-up a child window, instead
// we create a text file and show it as a message box.

	fprintf((FILE *) windowToDestroy, "%s\n\n", "Done.");
	
	fclose((FILE *) windowToDestroy);

	return 0;
}





///////////////////////////////////////////////////////////////////////////////
//
//	inline INT32 OS_Popup_ErrorMessageBox
//
//	Routine Description:
//		Performs a Message Box display, using Windows MessageBox command.
//
//	Note: This routine is standard for all Windows or DOS programs.
//
//	Arguments:
//		char *Text: Text to be displayed as message.
//		char *Caption: Text to be displayed about message origin or as title
//		errorCode: Error code number.
//
//	Return Value:
//		This is not a standard SI command and do not return error code,
//		instead, returns a True/False value from Windows function.
//
//	Revision Notes:
//		2007-04-24:
//			Created by Iley.
//

INT32 OS_Popup_ErrorMessageBox
(
    char *text,
    char *caption,
	int errorCode,
	UINT32 type
)
{
	char concatMessage[1024];

	sprintf(concatMessage, "%s\nCode = : %d\n", text, errorCode);
	OS_Popup_MessageBox(concatMessage, caption, type);

	return e_Err_NoError;
}


///////////////////////////////////////////////////////////////////////////////
//
//	inline INT32 OS_GetTickCount
//
//	Routine Description:
//		Gets the tick count of the computer's clock.
//
//	Arguments:
//		None.
//
//	Return Value:
//		A number representing the number of ticks the computers clock has count
//			since it was turned on..
//
//	Revision Notes:
//		2007-08-07:
//			Created by Ley.
//

INT32 OS_GetTickCount()
{
	struct timeval timeofday;

	gettimeofday(&timeofday, NULL);

	return timeofday.tv_usec / 1000;
}
