///////////////////////////////////////////////////////////////////////////////
//	sicommon_plxc33.h
//
//	Description:
//		Common hardware access routines for PLX with C33. 
//		These calls are PLX C33 specific. In order to use the SI PLX board, 
//		only this header file is included in the project. This makes all PLX
//		and SI specific PLX call available (including bit file loading and 
//		coff parsing). See the sample program.
//
//	Revision History:
//		2002-03-04: mik
//			Created.
//		2002-03-18: mik
//			Modified and added FIFO based communications (DSP Active).
//		2002-04-17: mik
//			Shuffled #define paths to reflect directory changes.
//		2002-04-18: mik
//			Moved rudimentary addon-initiated to sicommon_plx.xxx.
//			Redefined target/bmdma (only byte boundary).
//		2002-06-25: mik
//			Changed comm mode to new method using bits.
//			Removed read/write CSR calls (not used).
//		2002-07-01: mik
//			Changed all instances of SIHW_ to SI_
//		2002-09-16: mik
//			Moved all pOverlapped and callback stuff into API.
//		2003-06-20: Ley
//			Made changes based on changes by Mik in sicommon_plxc6711.h
//			Added extra parameter loading for COFF loading.
//			Added SI_PLXC33_ParseCoff
//
///////////////////////////////////////////////////////////////////////////////

#include "../../common/sihw_common_plx.h"	// common for all si plx boards

///////////////////////////////////////////////////////////////////////////////
//	C33 addresses as seen by DSP
//
//	All kPLXC33_CommReg are DWord addresses as seen from DSP

//	Starting offset for Communication Registers
#define kPLXC33_CommReg			0x30	
#define	kPLXC33_CommReg_Type	(kPLXC33_CommReg + 0x0 )
#define	kPLXC33_CommReg_Count	(kPLXC33_CommReg + 0x1 )
#define	kPLXC33_CommReg_AddrSrc	(kPLXC33_CommReg + 0x2 )
#define	kPLXC33_CommReg_AddrDst	(kPLXC33_CommReg + 0x3 )
#define	kPLXC33_CommReg_Flag	(kPLXC33_CommReg + 0x4 )
#define	kPLXC33_CommReg_Data	(kPLXC33_CommReg + 0x5 )

#define kPLXC33_CommReg_HostAddr		0x00C00000			

#define kPLXC33_CoffLoadOffset			0x00010000

// *** recheck these 2 pointers and confirm in DSP code ***
#define kPLXC33_QListPointers			0x00000280

#define kPLXC33_gTaskAddr				0x00000080
//	Following value can be 512 for C33, kept 128 in compatibility with C6711
//	Even in C6711, 128 locations are reserved from .cmd file, But uses only
//	as much as variable needs.
#define kPLXC33_gTaskSize				128

#define kPLXC33_ResetVectorAddr			0x00000000

///////////////////////////////////////////////////////////////////////////////
//	See comments for SI_PLXC33_ConvertDSPAddress to see how the conversion 
//	is done. Note that these are DSP addresses as seen from the DSP side.
//	Equivalent PLX addresses are computed when these values are passed 
//	through SI_PLXC33_ConvertDSPAddress function.

#define kPLXC33_IntDSPAddr			0xFF0001 // 0x1F0001
#define	kPLXC33_IntDSPValue			(0x1)

//	These are registers. They can be write/read.
#define kPLXC33_CSRAddr				0xFF0000 // 0x1F0000
#define kPLXC33_CSRBit_Reset		0	

///////////////////////////////////////////////////////////////////////////////
// Valid DSP Active communication modes.

enum e_CommModeIdx
{
	e_CommModeIdx_Addon_Async_IO_Int = 0, 
	e_CommModeIdx_Addon_Async_DMA_Int,

	e_CommModeIdx_Point_Sync_IO_Target_CommReg
};

///////////////////////////////////////////////////////////////////////////////
// Begin: Only for C33 PCI

INT32 SI_PLXC33_OpenDriver
(
	UINT32 board, 
	PPLXDevice pPLXDev
);

INT32 SI_PLXC33_ResetBoard
(
	PPLXDevice pPLXDev, 
	UINT32 resetMode
);

INT32 SI_PLXC33_ParseCoff
(
	PPLXDevice pPLXDev, char *filename, 
	UINT32 *dspMem, UINT32 dspMemCount, UINT32 *dspMemLoc, 
	UINT32 *wordsBeforeCoff, UINT32 *wordsAfterCoff, UINT32 *wordsAfterEnd
);

INT32 SI_PLXC33_CoffLoad
(
	PPLXDevice pPLXDev, 
	char *filename, UINT32 coffOptions, 
	UINT32 *wordsBeforeCoff, UINT32 *wordsAfterCoff, UINT32 *wordsAfterEnd
);

INT32 SI_PLXC33_CoffVerify
(
	PPLXDevice pPLXDev, 
	char *filename, UINT32 coffOptions, 
	UINT32 *wordsBeforeCoff, UINT32 *wordsAfterCoff, UINT32 *wordsAfterEnd
);

INT32 SI_PLXC33_ReadTarget
(
	PPLXDevice pPLXDev, 
	UINT32 region, UINT32 count, UINT32 dspAddr, UINT32 *hostAddr
);

INT32 SI_PLXC33_WriteTarget
(
	PPLXDevice pPLXDev, 
	UINT32 region, UINT32 count, UINT32 dspAddr, UINT32 *hostAddr
);

INT32 SI_PLXC33_ReadBlockDMA
(
	PPLXDevice pPLXDev, 
	UINT32 count, UINT32 dspAddr, UINT32 *hostAddr
);

INT32 SI_PLXC33_WriteBlockDMA
(
	PPLXDevice pPLXDev, 
	UINT32 count, UINT32 dspAddr, UINT32 *hostAddr
);

INT32 SI_PLXC33_ReadHostpoll
(
	PPLXDevice pPLXDev, 
	UINT32 count, UINT32 dspAddr, UINT32 *hostAddr
);

INT32 SI_PLXC33_WriteHostpoll
(
	PPLXDevice pPLXDev, 
	UINT32 count, UINT32 dspAddr, UINT32 *hostAddr
);

INT32 SI_PLXC33_ReadDSPActive
(
	PPLXDevice pPLXDev, 
	UINT32 commModeIndex, UINT32 count, UINT32 dspAddr, UINT32 *hostAddr
);

INT32 SI_PLXC33_WriteDSPActive
(
	PPLXDevice pPLXDev, 
	UINT32 commModeIndex, UINT32 count, UINT32 dspAddr, UINT32 *hostAddr
);

INT32 SI_PLXC33_TranslateCommModeIndex
(
	UINT32 commModeIndex, UINT32 *commMode, 
	UINT32 maxStringCount, char *commName
);
