///////////////////////////////////////////////////////////////////////////////
//	SIHW_Common_PLX.h
//
//	Description:
//		Common routines and defines for all SI boards with PLX.
//
//	Revision History:
//		2002-04-17: mik
//			Created.
//		2002-04-17: mik
//			Shuffled #define paths to reflect directory changes.
//		2002-06-14: mik
//			Removed sitypes.h since it's now in sicommon_plx.h
//		2002-06-18: mik
//			Redone DSP active communications. Application level interface is 
//			similar, but host/DSP communications now uses bits as definitions.
//		2002-07-01: mik
//			Changed all instances of SIHW_ to SI_
//		2002-07-09: mik
//			Added ParseBitFile func prototype (necessary evil).
//
///////////////////////////////////////////////////////////////////////////////
#if !defined(_SIHW_COMMON_PLX_H)
#define _SIHW_COMMON_PLX_H

#if defined(_cplusplus)
extern "C" {
#endif

#include "../../../../common/sicommon_plx.h"	// common for all PLX
#include "../../../../../common_sihw/sicodes.h"	// codes used by SI boards
#include "../../../../../common_sihw/coffparse.h"	// COFF parser

///////////////////////////////////////////////////////////////////////////////
//	Communications mode definitions, valid for host.

// DSP reads, host writes
#define kCommModeMask_DSPRead		0x00000001

// alert host via flag
#define kCommModeMask_InterruptHost	0x00000002	

// point transfers
#define kCommModeMask_PointTransfer	0x00000004	

// DSP transfers synchronously. 
//	On IO, synchronization occurs via the flag register.
//	On DMA, uses DSP's Asynchronous DMA or ext. HW/RDY synch.
#define kCommModeMask_Sync			0x00000008

// DSP transfers using DMA
#define kCommModeMask_DMA			0x00000100

// host reads from it's own memory since addon wrote to host mem directly.
#define kCommModeMask_HostAddonInit	0x00010000

// host access BMDMA/target
#define kCommModeMask_HostBMDMA		0x00020000

// Timeout value for waiting for DSP to ack. If the DSP is not valid by this 
//	time (ie, no ack from DSP per word), communications is in error.
#define kCommModeTimeoutValue		100		// msec

///////////////////////////////////////////////////////////////////////////////
//	DSP flag register definitions

// Host wrote all parameters and host is ready/waiting for DSP
#define	kCommModeFlag_HostReady		0x00000000

// DSP received valid command and the command is being executed
#define	kCommModeFlag_ValidCommand	0x00000001

// DSP completed the command without errors.
#define	kCommModeFlag_DSPDone		0x00000002

// DSP is dead or dying.
#define	kCommModeFlag_DSPCritical	0x00000004

///////////////////////////////////////////////////////////////////////////////
//	Following funcs are in configFPGA_PLX9054.cpp

#define kMaxFPGAs		0x00000100

#define kMaskFpgaPROGRAM	0x00010000
#define kMaskFpgaCCLK		0x01000000
#define kMaskFpgaDIO		0x04000000
#define kMaskFpgaDONE		0x00020000


INT32 SI_ConfigFPGA_Many
(
	struct PLXDevice *pPLXDev, 
	UINT32 fpgaCount, char *filenames[], char *fpganames[]
);

int ParseCommandLine
(
	int argc, char *argv[], UINT32 *boardID, char **filepath
);

int LoadBoardFPGAs
(
	UINT32 boardID, struct PLXDevice *pPLXDev, char *descriptionFilePath
);

int ParseDescriptionFile
(
	struct PLXDevice *pPLXDev, UINT32 boardID, char *descriptionFilePath,
	int bufferSize, char *buffer, UINT32 *numberOfFPGAs,
	char *fpganames[], char *bitfilenames[]
);

int LoadMultipleFPGA
(
		struct PLXDevice *pPLXDev, UINT32 numberOfFPGAs,
		char *fpganames[], char *bitfilenames[]
);

INT32 SI_ConfigFPGA_Initialize
(
	struct PLXDevice *pPLXDev
);

void DoError(char *errorMsg);

#if defined(_cplusplus)
}
#endif
#endif

