///////////////////////////////////////////////////////////////////////////////
//	sicommon_plx.h
//
//	Description:
//		Common hardware access routines for PLX. These calls are PLX specific.
//
//	Revision History:
//		2002-03-04: mik
//			Created.
//		2002-03-19: mik
//			Renamed AddonInit constants to DSPActiveComm constants.
//		2002-04-12: mik
//			Added FPGALoad parameter for indicator
//		2002-04-16: mik
//			Added SI_PLX_DriverConfig_BlockPoint.
//		2002-04-17: mik
//			Shuffled #define paths to reflect directory changes. Note that
//			the SIDDKAPI.H is not visible here and it should not be visible
//			anywhere else except sicommon_plx.cpp.
//			Added opendriver calls.
//		2002-06-14: mik
//			Added sitypes.h to overcome MS problem of bad basetsd.h file.
//		2002-06-25: mik
//			Added kAddonTransferTimout_Max to simplify timeout for addon-init.
//		2002-06-28: mik
//			Added SI_PLX_ConvertBenchmarkToSeconds.
//		2002-07-01: mik
//			Changed all instances of SIHW_ to SI_
//		2002-07-03: mik
//			Replaced SI_OpenDriver to SI_PLX_OpenDriver.
//		2002-09-16: mik
//			Moved all pOverlapped and callback stuff into API (see .cpp file).
//		2002-09-27: mik
//			Removed SI_PLX_SetupCallbackEvent (only used in cpp).
//		2002-11-15: mik
//			Moved SI_PLX_SetupCallbackEvent back to .h (for Linux compatibility)
//		2003-05-22: mik
//			Added SI_PLX_WaitInterruptFromDSP.
//
///////////////////////////////////////////////////////////////////////////////
#if !defined(_SICOMMON_PLX_H)
#define _SICOMMON_PLX_H

#if defined(_cplusplus)
extern "C" {
#endif

#include "sicommon_plx_types.h"
#include "90xxdef.h"					// 90xx register definitions
#include "../../common_ddk/sierrors.h"		// error codes

///////////////////////////////////////////////////////////////////////////////
//	Flags for all chipsets

//	Driver config flags
#define kFlagDriverConfig_Block		1
#define kFlagDriverConfig_Point		2

///////////////////////////////////////////////////////////////////////////////
//	Addon-init transfer timeout values. Change these to suit your hardware
//	transfer speed.

//	Maximum amount of time to wait for addon side to signal the host
//	via interrupt in msec.
#define kAddonTransferTimout_Max	5000

///////////////////////////////////////////////////////////////////////////////
// Begin: Common to all PLX devices

INT32 SI_PLX_ConvertBenchmarkToSeconds ( UINT32 *elapsedMsec );

INT32 SI_PLX_Sleep( UINT32 sleepMSec );

INT32 SI_PLX_OpenDriver
(
	UINT32 board, struct PLXDevice *pPLXDev
);

INT32 SI_PLX_CloseDriver
(
	struct PLXDevice *pPLXDev
);

INT32 SI_PLX_DriverConfig_BlockPoint
(
	struct PLXDevice *pPLXDev, 
	UINT32 pointOrBlock
);	

INT32 SI_PLX_ReadTarget8
(
	struct PLXDevice *pPLXDev, 
	UINT32 region, UINT32 count, UINT32 addonAddr, UINT8 *hostAddr
);

INT32 SI_PLX_ReadTarget16
(
	struct PLXDevice *pPLXDev, 
	UINT32 region, UINT32 count, UINT32 addonAddr, UINT16 *hostAddr
);

INT32 SI_PLX_ReadTarget
(
	struct PLXDevice *pPLXDev, 
	UINT32 region, UINT32 count, UINT32 addonAddr, UINT32 *hostAddr
);

INT32 SI_PLX_WriteTarget8
(
	struct PLXDevice *pPLXDev, 
	UINT32 region, UINT32 count, UINT32 addonAddr, UINT8 *hostAddr
);

INT32 SI_PLX_WriteTarget16
(
	struct PLXDevice *pPLXDev, 
	UINT32 region, UINT32 count, UINT32 addonAddr, UINT16 *hostAddr
);

INT32 SI_PLX_WriteTarget
(
	struct PLXDevice *pPLXDev, 
	UINT32 region, UINT32 count, UINT32 addonAddr, UINT32 *hostAddr
);

INT32 SI_PLX_ReadBlockDMA
(
	struct PLXDevice *pPLXDev, 
	UINT32 count, UINT32 addonAddr, UINT32 *hostAddr
);

INT32 SI_PLX_WriteBlockDMA
(
	struct PLXDevice *pPLXDev, 
	UINT32 count, UINT32 addonAddr, UINT32 *hostAddr
);

INT32 SI_PLX_CancelBlockDMA
(
	struct PLXDevice *pPLXDev
);

INT32 SI_PLX_SetTimeout
(
	struct PLXDevice *pPLXDev, UINT32 value
);

INT32 SI_PLX_ReadPCI_OpReg
(
	struct PLXDevice *pPLXDev, 
	UINT32 count, UINT32 opRegNum, UINT32 *values
);

INT32 SI_PLX_WritePCI_OpReg
(
	struct PLXDevice *pPLXDev, 
	UINT32 count, UINT32 opRegNum, UINT32 *values
);

INT32 SI_PLX_ReadMailbox
(
	struct PLXDevice *pPLXDev, 
	UINT32 count, UINT32 mailboxNum, UINT32 *values	
);

INT32 SI_PLX_WriteMailbox
(
	struct PLXDevice *pPLXDev, 
	UINT32 count, UINT32 mailboxNum, UINT32 *values	
);

INT32 SI_PLX_ReadPCI_ConfSpace
(
	struct PLXDevice *pPLXDev, 
	UINT32 count, UINT32 offset, UINT32 *values	
);

INT32 SI_PLX_ReadPCI_NVWord
(
	struct PLXDevice *pPLXDev, 
	UINT32 count, UINT32 addrNVRam, UINT32 *values
);

INT32 SI_PLX_WritePCI_NVWord
(
	struct PLXDevice *pPLXDev, 
	UINT32 count, UINT32 addrNVRam, UINT32 *values	
);

INT32 SI_PLX_DirectAccessAddr
(
	struct PLXDevice *pPLXDev, 
	UINT32 count, UINT32 *addr[]	
);

INT32 SI_PLX_ReleaseDirectAccessAddr
(
	struct PLXDevice *pPLXDev
);

INT32 SI_PLX_GetAddonBufferAddr
(
	struct PLXDevice *pPLXDev, 
	UINT32 registerToUse
);

INT32 SI_PLX_ReleaseAddonBufferAddr
(
	struct PLXDevice *pPLXDev
);

INT32 SI_PLX_WaitInterruptFromDSP
(
	struct PLXDevice *pPLXDev, 
	INT32 waitMilliSecs
);

INT32 SI_PLX_WaitMessageFromDSP
(
	struct PLXDevice *pPLXDev, 
	INT32 waitMilliSecs
);

// End: Common to all PLX devices

// Begin: Added by SI to support features of PLX

INT32 SI_PLX_ReadAddonInit
(
	struct PLXDevice *pPLXDev, 
	UINT32 interruptAddr, UINT32 interruptValue,
	UINT32 count, UINT32 *hostAddr
);

INT32 SI_PLX_WriteAddonInit
(
	struct PLXDevice *pPLXDev, 
	UINT32 interruptAddr, UINT32 interruptValue,
	UINT32 count, UINT32 *hostAddr
);

INT32 SI_PLX_SetupAddonInitParams
(
	struct PLXDevice *pPLXDev, 
	UINT32 addonAddr, 
	UINT32 mode, UINT32 count, UINT32 srcAddr, UINT32 dstAddr
);

INT32 SI_PLX_SetupCallbackEvent
(
	struct PLXDevice *pPLXDev, void *callbackFunction
);

INT32 SI_PLX_SetupMessageEvent
(
	struct PLXDevice *pPLXDev
);

// End: Added by SI to support features of PLX
#if defined(_cplusplus)
}
#endif
#endif
