///////////////////////////////////////////////////////////////////////////////
//	SIErrors.h
//
//	Sheldon Instruments, Inc.
//
//	Description:
//		Various function to support translation of error code to text.
//
//	Functions:
//		TranslateErrorCode
//
//	Revision History:
//		2002-04-12: mik
//			Created.
//			Added TranslateErrorCode function.
//		2002-04-17: mik
//			Changed name/path to sierrors in siddk directory.
//	
///////////////////////////////////////////////////////////////////////////////

#include "sierrors.h"
#include <stdio.h>

///////////////////////////////////////////////////////////////////////////////

int TranslateErrorCode(int error, char errorMsg[])
{
	switch(error)
	{
	// System errors
	case e_Err_DeviceNotFound: // arbituary, tobe backward compatib
		sprintf(errorMsg, "Error: Device not found.");
		break;

	case e_Err_BadVendorID:
		sprintf(errorMsg, "Error: Bad vendor ID.");
		break;

	// Following are not-so-serious errors, to be continued below
	case e_Err_ScopeUnderflow:
		sprintf(errorMsg, "Warning: Scope underflow.");
		break;

	case e_Err_NoError:
		sprintf(errorMsg, "Warning: No error.");
		break;


	// misc errors
	case e_Err_MiscError:
		sprintf(errorMsg, "Error: Misc error.");
		break;
	case e_Err_UnknownCommand:
		sprintf(errorMsg, "Error: Unknown command.");
		break;
	case e_Err_EventSetup:
		sprintf(errorMsg, "Error: Event Setup.");
		break;
	case e_Err_MsgError:
		sprintf(errorMsg, "Error: Messaging Error.");
		break;
	case e_Err_InvalidNumOfParams:
		sprintf(errorMsg, "Error: Invalid Number of Parameters.");
		break;
	case e_Err_InvalidParams:
		sprintf(errorMsg, "Error: Invalid Parameters.");
		break;


	// Buffer errors
	case e_Err_Timeout:
		sprintf(errorMsg, "Error: Timeout.");
		break;
	case e_Err_BufferTooSmall:
		sprintf(errorMsg, "Error: Buffer too small.");
		break;
	case e_Err_CountTooBig:
		sprintf(errorMsg, "Error: Count too big.");
		break;
	case e_Err_CompareError:
		sprintf(errorMsg, "Error: Compare error.");
		break;
	case e_Err_DSPOutofMemory:
		sprintf(errorMsg, "Error: DSP out of memory.");
		break;
	case e_Err_DSPAllocateBuffer:
		sprintf(errorMsg, "Error: DSP allocate buffer.");
		break;
	case e_Err_ScopePointerError:
		sprintf(errorMsg, "Error: Scope pointer error.");
		break;


	// Read errors
	case e_Err_ReadError:
		sprintf(errorMsg, "Error: Read error.");
		break;
	case e_Err_NotAllWordsRead:
		sprintf(errorMsg, "Error: Not all words read.");
		break;
	case e_Err_OpregReadError:
		sprintf(errorMsg, "Error: Opreg read.");
		break;
	case e_Err_TargetReadError:
		sprintf(errorMsg, "Error: Target read.");
		break;
	case e_Err_BusmasterReadError:
		sprintf(errorMsg, "Error: Busmaster read.");
		break;
	case e_Err_AddonInitReadError:
		sprintf(errorMsg, "Error: Addon init read.");
		break;
	case e_Err_HostpollReadError:
		sprintf(errorMsg, "Error: Hostpoll read.");
		break;
	case e_Err_NVReadError:
		sprintf(errorMsg, "Error: NV read.");
		break;


	// Write errors
	case e_Err_WriteError:
		sprintf(errorMsg, "Error: Write error.");
		break;
	case e_Err_NotAllWordsWrite:
		sprintf(errorMsg, "Error: Not all words wrote.");
		break;
	case e_Err_OpregWriteError:
		sprintf(errorMsg, "Error: Opreg write.");
		break;
	case e_Err_TargetWriteError:
		sprintf(errorMsg, "Error: Target write.");
		break;
	case e_Err_BusmasterWriteError:
		sprintf(errorMsg, "Error: Busmaster write.");
		break;
	case e_Err_AddonInitWriteError:
		sprintf(errorMsg, "Error: Addon init write.");
		break;
	case e_Err_HostpollWriteError:
		sprintf(errorMsg, "Error: Hostpoll write.");
		break;
	case e_Err_NVWriteError:
		sprintf(errorMsg, "Error: NV write.");
		break;


	// DSP Errors
	case e_Err_ResetError:
		sprintf(errorMsg, "Error: DSP Reset.");
		break;
	case e_Err_ResetInvalidMode:
		sprintf(errorMsg, "Error: Invalid reset mode.");
		break;
	case e_Err_ResetAssertError:
		sprintf(errorMsg, "Error: Reset assert.");
		break;
	case e_Err_ResetDeassertError:
		sprintf(errorMsg, "Error: Reset deassert.");
		break;
	case e_Err_ResetTBCError:
		sprintf(errorMsg, "Error: TBC reset.");
		break;
	case e_Err_AddonInitTimeoutError:
		sprintf(errorMsg, "Error: Addon init timout.");
		break;
	case e_Err_NoInterruptFromDSP:
		sprintf(errorMsg, "Error: No Interrupt from DSP.");
		break;


	// Following are used by ISA
	case e_Err_FileTooLarge:
		sprintf(errorMsg, "Error : File Too Large.");
		break;
	case e_Err_StatusBitError:
		sprintf(errorMsg, "Error : Invalid Status Bit.");
		break;
	case e_Err_ISACommError:
		sprintf(errorMsg, "Error : ISA Commn Error.");
		break;
	case e_Err_ISAClearHandshake:
		sprintf(errorMsg, "Error : ISA CLear HandShake.");
		break;
	case e_Err_BeginCmdSend:
		sprintf(errorMsg, "Error : Begin Cmd Send.");
		break;
	case e_Err_ISASendType:
		sprintf(errorMsg, "Error : ISA Send Type.");
		break;
	case e_Err_ISASendCount:
		sprintf(errorMsg, "Error : ISA Send Count.");
		break;
	case e_Err_ISASendSrc:
		sprintf(errorMsg, "Error : ISA Send Src.");
		break;
	case e_Err_ISASendDst:
		sprintf(errorMsg, "Error : ISA Send Dst.");
		break;
	case e_Err_ISAStatusValueError:
		sprintf(errorMsg, "Error : ISA Status Value Error.");
		break;


	// Following are used by CAC
	case e_Err_FdspHalt:
		sprintf(errorMsg, "Error : Dsp halted.");
		break;
	case e_Err_FdspDlExec:
		sprintf(errorMsg, "Error : DSP DL Exec.");
		break;
	case e_Err_FfindLabelName:
		sprintf(errorMsg, "Error : Find label Name.");
		break;
	case e_Err_FdspRun:
		sprintf(errorMsg, "Error : Dsp Running.");
		break;


	// Following are used by C6x parallel
	case e_Err_ClassInitError:
		sprintf(errorMsg, "Error: Class init.");
		break;
	case e_Err_CloseError:
		sprintf(errorMsg, "Error: Close.");
		break;
	case e_Err_PortOpenError:
		sprintf(errorMsg, "Error: Port open.");
		break;
	case e_Err_CoffloadError:
		sprintf(errorMsg, "Error: Coffload.");
		break;
	case e_Err_GenerateIntError:
		sprintf(errorMsg, "Error: Generate interrupt.");
		break;


	// Following are used by PLXC6711
	case e_Err_SdramAckError:
		sprintf(errorMsg, "Error: SDRAM EEPROM did not return ACK.");
		break;
	case e_Err_SdramConfig_tCL:
		sprintf(errorMsg, "Error: Invalid CAS latency in SDRAM EEPROM.");
		break;
	case e_Err_SdramConfig_tREFI:
		sprintf(errorMsg, "Error: Invalid refresh in SDRAM EEPROM.");
		break;
	case e_Err_SdramConfig_colSize:
		sprintf(errorMsg, "Error: Invalid column size in SDRAM EEPROM.");
		break;
	case e_Err_SdramConfig_rowSize:
		sprintf(errorMsg, "Error: Invalid row size in SDRAM EEPROM.");
		break;
	case e_Err_SdramConfig_bankSize:
		sprintf(errorMsg, "Error: Invalid bank size in SDRAM EEPROM.");
		break;
	case e_Err_SdramConfig_DeviceAddr:
		sprintf(errorMsg, "Error: Invalid Device Address.");
		break;
	case e_Err_SdramConfig_Param:
		sprintf(errorMsg, "Error: Invalid parameter in SDRAM EEPROM.");
		break;


	// File system errors
	case e_Err_FileNotFound:
		sprintf(errorMsg, "Error: File not found.");
		break;
	case e_Err_CreateFile:
		sprintf(errorMsg, "Error: CreateFile Windows API failed.");
		break;
	case e_Err_UnableToReadFile:
		sprintf(errorMsg, "Error: Unable to read file.");
		break;
	case e_Err_WindowsHandle:
		sprintf(errorMsg, "Error: Invalid Windows handle.");
		break;
	case e_Err_WindowsMemError:
		sprintf(errorMsg, "Error: Windows memory error.");
		break;
	case e_Err_InvalidFile:
		sprintf(errorMsg, "Error: Invalid file.");
		break;
	case e_Err_FileWriteError:
		sprintf(errorMsg, "Error: File Write error.");
		break;
	case e_Err_FileReadError:
		sprintf(errorMsg, "Error: File Read error.");
		break;


	// Following are not-so-serious errors
	//	see above for this error. e_Err_ScopeUnderflow = 1, 
	case e_Err_ScopeTrigger:
		sprintf(errorMsg, "Error : Scope Trigger.");
		break;
	case e_Err_ScopeADCOff:
		sprintf(errorMsg, "Error : Scope AD Coff.");
		break;
	case e_Err_ScopeOverflow:
		sprintf(errorMsg, "Error : Scope Overflow.");
		break;


	// Following are bit file loader specific errors.
	case e_Err_FPGA_DoneNotLow:
		sprintf
		(
			errorMsg, 
			"Error: FPGA done pin not low. Program pin toggle failed."
		);
		break;
	case e_Err_FPGA_DoneNotHigh:
		sprintf
		(
			errorMsg, 
			"Error: FPGA done pin not high. FPGA is not configured."
		);
		break;
	case e_Err_FPGA_TypeNotFound:
		sprintf(errorMsg, "Error: FPGA type not found.");
		break;
	case e_Err_FPGA_NotAllFPGALoaded:
		sprintf(errorMsg, "Error: Not all FPGAs are loaded.");
		break;
	case e_Err_FPGA_MaxNumberOfFPGAs:
		sprintf(errorMsg, "Error: Max. number of FPGAs per board reached.");
		break;


	// Following are COFF loader specific errors.
	case e_Err_CoffTypeError:
		sprintf(errorMsg, "Error: Invalid COFF type.");
		break;
	case e_Err_CoffSectionsError:
		sprintf(errorMsg, "Error: Invalid COFF section.");
		break;


	// errors caused by formula node (todo: is this needed?)
	case e_Err_IndexOutofBounds:
		sprintf(errorMsg, "Error: Index Out of Bounds.");
		break;


	//Following are only for VQ host dll and used by SI boards only.
	case e_Err_GetGeneration:
		sprintf(errorMsg, "Error: Invalid generation.");
		break;
	case e_Err_GetCurVQFelAddr:
		sprintf(errorMsg, "Error: Invalid VQ Fel Addr.");
		break;
	case e_Err_AddToPQFList:
		sprintf(errorMsg, "Error: Invalid PQ Fel Addr.");
		break;
	case e_Err_AddToFlist:
		sprintf(errorMsg, "Error: Invalid VQ Fel Addr.");
		break;

	// Following are DOS DDK error codes
	case e_Err_PCIBIOSCallFailed:
		sprintf(errorMsg, "Error: PCI BIOS call failed.");
		break;
	case e_Err_DMPIBIOSCallFailed:
		sprintf(errorMsg, "Error: DMPI BIOS call failed.");
		break;
	case e_Err_PCIBIOSNotPresent:
		sprintf(errorMsg, "Error: PCI BIOS not present.");
		break;
	case e_Err_PCISignature:
		sprintf(errorMsg, "Error: PCI signature.");
		break;
	case e_Err_ClassNotFound:
		sprintf(errorMsg, "Error: Class not found.");
		break;
	case e_Err_SpecialCycles:
		sprintf(errorMsg, "Error: Special cycles.");
		break;
	case e_Err_InvalidBitWidth:
		sprintf(errorMsg, "Error: Invalid Bit width.");
		break;
	case e_Err_ReadConfig:
		sprintf(errorMsg, "Error: Read Configuration.");
		break;
	case e_Err_WriteConfig:
		sprintf(errorMsg, "Error: Write Configuration.");
		break;
	case e_Err_HostTooFast:
		sprintf(errorMsg, "Error: Host too Fast.");
		break;


	// following are synchronous read/write errors
	case e_Err_SyncAccessNotReady:
		sprintf(errorMsg, "Error: Sync access not ready.");
		break;

	
	//Following are send and receive messaging errors
	case e_Err_RecvMsg_NoMsg:
		sprintf(errorMsg, "Error: No Message received.");
		break;
	case e_Err_SendMsg_Pending:
		sprintf(errorMsg, "Error: Send Message pending.");
		break;
	case e_Err_SendMsg_Timeout:
		sprintf(errorMsg, "Error: Send Message timeout.");
		break;


	// last error is always the last error
	case e_Err_LastError:
		sprintf(errorMsg, "Error: Last error.");
		break;


	default:
		sprintf(errorMsg, "Critical: Unknown error code.");
		return e_Err_MiscError;
		break;
	}

	return e_Err_NoError;
}

///////////////////////////////////////////////////////////////////////////////

