////////////////////////////////////////////////////////////////////////////////
//	CBoard.cpp
//
//	Sheldon Instruments, Inc.
//
//	Abstract:
//		Function which are not defined in all classes have defaults here.
//
//	Functions:
//		SIDebugPrint
//		CBoard::CoffQuListfromFile
//		CBoard::CloseQuListFileandLaunch
//
//	Revision History:
//
//		1998-01-13: Robert Updike
//			Modified
//		2001-08-24: mik
//			Changed error return types to use VQ_Error enum values.
//		2001-08-29: mik
//			Removed unused funcs: 
//				virtual UINT32 Conv_GetDSPAddress(UINT32 address);
//				virtual UINT32 Conv_DSPAddr2Q(UINT32 address);
//		2001-11-08: mik
//			Changed Get/Set NV Bytes to return word intead of byte.
//		2001-11-15: mik
//			Cleaned up comment section
//		2002-01-17: mik
//			Added ReadPCI_NVWord, WritePCI_NVWord.
//			Added ReadPCI_OpReg, WritePCI_OpReg.
//		2002-01-25: mik
//			Removed DebugSaveToFile function (better debug tool avail)
//		2002-01-28: mik
//			Moved void SIDebugPrint( char *format, ... ) from vqhost.cpp to 
//				CBoard.cpp
//		2004-08-11: Ley
//			Added CoffLoad to Flash memory. It uses a creates a file in the
//			Hard Disk, concatenating original PARSED Coff file, plus whatever
//			PQ & VQ lists need, then at Finish uses this file with a complete
//			process of Coff Load & Launch to start DSP. Note this Coff file format
//			differs from TI .out files, this one is dumped into DSP as is, without
//			further parsing. Also created a new window class for notifying customer
//			to wait 20 - 25 seconds while Flash is erased and loaded. This messaging
//			window can be of further use.
//		2006-10-16: Ley
//			Expanded GetBoardInfo so now it also outputs
//			DSP Bus Speed and Boundary Factor.
//		2007-03-13
//			Split into CBoard.cpp and CQuXBoard.cpp.
//			CBoard.cpp sent down to SI-DDK level, intended to become classes for
//			SI boards, mainly for SISamp programs.
//			CQuXBoard.cpp is kept at VQHost level, intended to eliminate SI Board
//			specific stuff and keep only VQHost clases, which will include
//			SI Board classes.
//			The goal is, from PCI classes build SI_Board classes, then build VQHost
//			classes.
//			Will need a lot of further work.
//
//TODO: 
//	Change all comments to reflect VQ_Error return values.
//
////////////////////////////////////////////////////////////////////////////////

#include "cboard.h"
////////////////////////////////////////////////////////////////////////////////

//	This is defined in project settings.
#ifdef CS_DEBUG_TO_FILE	

void SIDebugPrint( char *format, ... )
{
	FILE *fp;
	va_list arglist;

	fp = fopen(kSIDebugFilename, "at");
	if (fp == NULL)
		return;

	va_start( arglist, format );
	vfprintf( fp, format, arglist );
	va_end ( arglist );

	fclose(fp);
}

#endif
// end debug print to file definitions

////////////////////////////////////////////////////////////////////////////////
/*

Routine Description:

	Returns board info, the DSP type and host interface type.
	
Arguments:

    data - pointer to buffer where the data is located.

Return Value:

	e_Err_NoError
*/

/*
INT32 CBoard::GetBoardInfo(UINT32 *data)
{
	data[0] = boardInfo.cgHostBus;
	data[1] = boardInfo.dspType;
	data[2] = boardInfo.cgDSP_Bank0;	// Memory data available only after Coffload
	data[3] = boardInfo.cgDSP_Bank1;	// Memory data available only after Coffload
	data[4] = boardInfo.dspBusClkIndex;
	data[5] = cgDSP_DataSize;
	return e_Err_NoError;
}
*/

// Following is for C30 to IEEE conversion
INT32 Conv_Float_DSP2Host(UINT32 size, UINT32 *dataIn, float *dataOut)
{
	register UINT32 cnt;
	register UINT32 temp, result;
	UINT32 *tempData;

	tempData = (UINT32 *) dataOut;					// tempData will point to dataOut
													// but will treat them as UINT32
													// so can do all bit manupulations.

	for(cnt = 0; cnt < size; cnt++)
	{
		tempData[cnt] = dataIn[cnt];

		// special case of 0 
		if((tempData[cnt] & 0xff000000) == 0x80000000)
			result = 0;
		else if(tempData[cnt] & 0x00800000)			// if C30 float is negative
		{
			temp = tempData[cnt] & 0x007fffff;		// temp = f 
			temp |= 0xff000000;						// sign extend f
			temp = ~temp;							// take 2s compliment
			temp += 1;

			result = tempData[cnt] & 0xff000000;	// zero f, sign bit
			result += 0x7f000000;					// bias exponent

			if(temp & 0x01000000)					// overflow on 2s compliment
				result += 0x01000000;

			result = result >> 1;					// shift e
			result |= temp & 0x007fffff;			// add f
			result |= 0x80000000;					// set sign bit
		}
		else
		{
			result = tempData[cnt] & 0xff000000;	// zero f
			result += 0x7f000000;					// bias exponent
			result = result >> 1;					// shift e
			result &= 0x7fffffff;					// zero sign bit
			result |= tempData[cnt] & 0x007fffff;	// add f
		}

		tempData[cnt] = result;
	}

	return e_Err_NoError;
}

// Following is for IEEE to C30 conversion
INT32 Conv_Float_Host2DSP(UINT32 size, float *dataIn, UINT32 *dataOut)
{
	// method from TI databook, according to their table.
	UINT32 exponent, sign, mantissa, cnt;
	UINT32 *tempData;

	tempData = (UINT32 *) dataIn;					// tempData will point to dataOut
													// but will treat them as UINT32
													// so can do all bit manupulations.

	for (cnt=0; cnt<size; cnt++)
	{
		dataOut[cnt] = tempData[cnt];

		sign =		( dataOut[cnt] >> 31 ) & 1;
		exponent =	( dataOut[cnt] >> 23 ) & 0xff;
		mantissa =	( dataOut[cnt]		  ) & 0x7fffff;

		if ( (exponent == 255) && (sign == 1) )
		{
			// 1 max neg inf
			exponent = 0x7f;
			sign = 1;
			mantissa = 0;
		}
		else if ( (exponent == 255) && (sign == 0) )
		{
			// 2 max pos inf
			exponent = 0x7f;
			sign = 0;
			mantissa = 0x7fffff;
		}
		else if ( (exponent > 0) && (exponent < 255) && (sign == 0) )
		{
			//3
			exponent = exponent - 0x7f;
			sign = 0;
			// no change mantissa
		}
		else if ( (exponent > 0) && (exponent < 255) && (sign == 1) )
		{
			if (mantissa != 0)
			{
				//4
				exponent = exponent - 0x7f;
				sign = 1;
				mantissa = ~mantissa + 1;
			}
			else
			{
				//5
				exponent = exponent - 0x80;
				sign = 1;
				mantissa = 0;
			}
		}
		else if (exponent == 0)
		{
			// 6 zero
			exponent = 0x80;
			sign = 0;
			mantissa = 0;
		}

		dataOut[cnt] = 
				( (exponent & 0xff ) << 24 )
			|	( (sign & 1) << 23 )
			|	( (mantissa & 0x7fffff) );
	}
	
	return e_Err_NoError;
}

/*
	old way
	register UINT32 cnt, mask;
	register UINT32 temp, result;


	for(cnt=0;cnt<size;cnt++)
	{
		if((temp = (data[cnt]) & 0x7F800000) == 0)	// if zero or unnormalized
		{
			if(((data[cnt]) & 0x00400000) == 0)
				result = 0x80000000;				// if unnormalized force to zero
			
			if((data[cnt] ^ 0x00400000) < 0)			// if msb of f=1 make it 0
				result ^= 0x00400000;
		}
		else if(temp = (temp ^ 0x7f800000) == 0)	// if NAN or INFINITY
		{
			if(temp = (temp & 0x007fffff) ==0)
				result = 0;
			else if(temp > 0)
				result = 0x7f7fffff;
			else
				result = 0x7f800000;
		}
		else
		{
			//temp = (INT32)(data[cnt] & 0xFF800000);	// Replace f with 0's
			temp = data[cnt] & 0xFF800000;	// Replace f with 0's
			result = temp + data[cnt];				// loose sign bit, shift e left 1, 
													// restore f
		
			if(result == 0L)						// Check for zero
				//result = (INT32) 0xFF000000;			// If zero set up result for C30 zero
				result = 0xFF000000;			// If zero set up result for C30 zero
			
			//result -= (INT32) 0x7F000000;			// Unbias exponent
			result -= 0x7F000000;			// Unbias exponent
		
			if(temp < 0L)							// Check original number for negative
			{                                          // If negative
				mask = 0x7FFFFF;				// mask for lower 23 bits
				result &= 0xFF800000;		// Clear f of result
				//temp = (INT32) (data[cnt] & mask);		// temp = f
				temp = data[cnt] & mask;		// temp = f
				temp = temp | 0xFF800000;
				temp = ~temp;
				temp += 1L;							// temp = f'' = 2's compliment(f)
				result += temp;						// add f'' to result

				if((result & 0x00800000))			// check C30 sign bit
					//result -= (INT32) 0x01000000;	// If set e = e-1
					result -= 0x01000000;	// If set e = e-1
				else
					//result |= (INT32) 0x00800000;	// else set sign bit
					result |= 0x00800000;	// else set sign bit
			}
		}

		data[cnt] = result;							// write result to array
	}

	return e_Err_NoError;
*/


// This function is used only for coffloading flash memory
// of C6711 Stand Alone version
//INT32 CoffQuListfromFile(char quListFilename[])
//{
//	return e_Err_NoError;
//}

//INT32 CloseQuListFileandLaunch(char quListFilename[])
//{
//	return e_Err_NoError;
//}
