///////////////////////////////////////////////////////////////////////////////
//	Board.h
//	
//	Sheldon Instruments, Inc.
//	
//	Abstract:
//	
//		Header file for the Board Class.
//	
//	Revision History:
//	
//		Feb1997 - created by cdk.
//		13Jan1998 - modified by Robert Updike
//		2001-03-09 - added C33PLX0954 class
//		2001-08-24: mik
//			Moved all enums to SICodes.h
//		2001-08-28: mik
//			Added kMAXTIMEOUT_MS. This should be used by all
//				timeout based calls.
//			Removed overlapped and replaced them all with 
//				cgOverlappedRead / cgOverlappedWrite / cgOverlappedMisc.
//				These are now in base class for all to use.
//		2001-08-29: mik
//			Removed unused funcs: 
//				virtual UINT32 Conv_GetDSPAddress(UINT32 address);
//				virtual UINT32 Conv_DSPAddr2Q(UINT32 address);
//			Removed CISABoard and CNTISABoard(CISABoard1 is used)
//		2001-08-30: mik
//			Added ifdef for C6711, CAC, LSI boards.
//		2001-11-08: mik
//			Changed Get/Set NV Bytes to return word intead of byte.
//		2001-11-15: mik
//			Cleaned up comment section
//		2002-01-17: mik
//			Added ReadPCI_NVWord, WritePCI_NVWord.
//			Added ReadPCI_OpReg, WritePCI_OpReg.
//		2002-01-25: mik
//			Removed DebugSaveToFile function (better debug tool avail)
//		2002-01-28: mik
//			Moved void SIDebugPrint( char *format, ... ) from vqhost.cpp to 
//				CBoard.cpp
//		2002-02-09: mik
//			Added CWin32DLL class.
//		2002-05-01: mik
//			Added CPLXC6711 class.
//		2002-05-03: mik
//			Moved ReadTarget to public since it's used by debug.
//		2002-07-01: mik
//			Changed C33PLXC9054 to CPLXC33.
//			Changed C6711PLXC9054 to CPLXC6711.
//		2002-07-08: mik
//			Using OverlappedEventsCreate to create all events.
//		2002-09-13: mik
//			Temporarily created CPCIBoard1 until AMCC API is modified to have
//			overlapped and callback embedded in them.
//		2002-09-16: mik
//			Minor clean up.
//		2002-10-07: mik
//			Using new API functions for AMCC.
//		2004-08-11: Ley
//			Added CoffLoad to Flash memory. It uses a creates a file in the
//			Hard Disk, concatenating original PARSED Coff file, plus whatever
//			PQ & VQ lists need, then at Finish uses this file with a complete
//			process of Coff Load & Launch to start DSP. Note this Coff file format
//			differs from TI .out files, this one is dumped into DSP as is, without
//			further parsing. Also created a new window class for notifying customer
//			to wait 20 - 25 seconds while Flash is erased and loaded. This messaging
//			window can be of further use.
//		2004-09-17: Ley
//			Modified so it configures memory size by getting memory available,
//			instead of using the Manual Control Setting.
//		2006-10-16: Ley
//			Expanded GetBoardInfo so now it also outputs
//			DSP Bus Speed and Boundary Factor.
//			For SISample related programs: Added read NVRam to have the DSP
//			Bus speed in order to calculate parameters for DDS
//			for Sampling Rate.
//		2007-03-13
//			Split into CBoard.cpp and CQuXBoard.cpp.
//			CBoard.cpp sent down to SI-DDK level, intended to become classes for
//			SI boards, mainly for SISamp programs.
//			CQuXBoard.cpp is kept at VQHost level, intended to eliminate SI Board
//			specific stuff and keep only VQHost clases, which will include
//			SI Board classes.
//			The goal is, from PCI classes build SI_Board classes, then build VQHost
//			classes.
//			Will need a lot of further work.
//
///////////////////////////////////////////////////////////////////////////////

// This file contains the class declaration for the Board class

#include <stdio.h>

#include "../siddk_plx/common/sicommon_plx_types.h"	// PLX based boards

#include "../common_ddk/sitypes.h"
#include "../common_ddk/sierrors.h"

#include "sicodes.h"

///////////////////////////////////////////////////////////////////////////////

//#define CS_INCLUDE_DLL		// uncomment to include DLL simulator
#define CS_INCLUDE_DLL

//#define CS_INCLUDE_C6711DSK2	// uncomment to include C6711DSK2
//		CS_INCLUDE_C6711DSK2 needs the following
//			C6711Par_CCS2.cpp
//			dsk6x11hpi.h
//			dsk6x11hpi.lib
//			Following in Windows\system (or places defined by %path%)
//				dsk6x11hpi.dll
//				dsk6x11pp.dll
//				xdsfast3.dll
//			Following in c:/sic30dsp/
//				dsk6x11spp378.cfg

//#define CS_INCLUDE_CAC		// uncomment to include CAC board
//		CS_INCLUDE_CAC needs the following
//			CCACBoard.cpp
//			D32util.h
//			d32util.lib
//			Following in windows\system
//				cacdsp.vxd
//				Cac_cfg.dll
//				d32util.dll
//			
//			
//			

//#define CS_INCLUDE_LSI		// uncomment to include LSI board
//		CS_INCLUDE_LSI needs the following
//			CLSIBoard.cpp
//			LSIBoard.h
//			c32devms.lib
//			tic32nt.h
//			
//			
//			

///////////////////////////////////////////////////////////////////////////////
// begin debug print to file definitions
#include <stdarg.h>

#define mSIDebugPrint( _x_ )
#define kSIDebugFilename		"C:\\dud.txt"

// we explicitly tell it to save debug to file. 
//	This is defined in project settings.
#ifdef CS_DEBUG_TO_FILE	

void SIDebugPrint( char *format, ... );
#define mSIDebugPrint
#define mSIDebugPrint( _x_ )	SIDebugPrint _x_ 

#endif
// end debug print to file definitions

#define kDSP_DATASIZE	gBoard[board]->boardInfo.cgDSP_DataSize

///////////////////////////////////////////////////////////////////////////////
//	CBoard
//		Base class for all other boards. This is almost pure virtual.
//
/*
class CBoard
{
	protected:

		enum e_CommModes
		{
			e_CommModes_Invalid = -1, 
		};

	public:

		virtual ~CBoard(){}

		SI_BoardInfo boardInfo, *pBoardInfo;

		//Used to switch between writing to a file or to a board
		UINT32	coffType;
		//filename
		char 	*quListFile;
		FILE	*quListfp;
		UINT32	savingQuListFile;
		UINT32  listSize;		 //used to compute the Pq/Vq list size.		
		UINT32	quListFileSize;

	//this is used to specify lel write or data write
	// dataType, to be used as Data Type in headers of
	// CoffLoad blocks.
	// 0 = Normal, DSP will verify values after parsing
	// 1 = Not verified by DSP after parsing
	// 2 = Not verified by DSP after parsing
	// 3 = Not verified by DSP after parsing
		UINT32	dataType;
		//for C3x, this is 1, for C6x and 80x86, this is 4
		//	this is how much the pointer should increment.
		//	For example, if 32 bit entity is used (default), this is 
		//		1 for C3x (32 bit addressing)
		//		4 for C6x (8 bit addressing)
		//	If 64 bit entity is used, this is
		//		2 for C3x
		//		8 for C6x
		//


//		virtual INT32 GetBoardInfo(UINT32 *data);


		// by default, these convert to/from IEEE/C3x format.
		virtual INT32 Conv_Float_Host2DSP(UINT32 size, float *dataIn, UINT32 *dataOut);
		virtual INT32 Conv_Float_DSP2Host(UINT32 size, UINT32 *dataIn, float *dataOut);

		// pure virtual begin
		virtual INT32 ClassLoad ( UINT32 *param ) = 0;
		virtual INT32 ClassUnload () = 0;

		virtual INT32 
			CoffLoad
			(
				char filename[], UINT32 cgMemModule, UINT32 delay, UINT32 launch,
				UINT32	*coffImageSize 

			) = 0;

		virtual INT32 ResetBoard(UINT32 duration) = 0;

		virtual	INT32 Configure(UINT32 *params) = 0;

		virtual	INT32
			ReadFromBoard
			(
				UINT32 count, UINT32 addr, UINT32 *hostAddr
			) = 0;
		virtual	INT32
			WriteToBoard
			(
				UINT32 count, UINT32 addr, UINT32 *hostAddr
			) = 0;

		virtual INT32
			ReadGeneric
			(
				UINT32 mode, UINT32 count, UINT32 addr, UINT32 *hostAddr
			) = 0;

		virtual INT32
			WriteGeneric
			(
				UINT32 mode, UINT32 count, UINT32 addr, UINT32 *hostAddr
			) = 0;

		virtual INT32 CoffQuListfromFile(char quListFilename[]);
		virtual INT32 CloseQuListFileandLaunch(char quListFilename[]);

		// pure virtual end
};


#ifndef vqhost_EXPORTS

///////////////////////////////////////////////////////////////////////////////

class CPCIBoard: public CBoard
{
	protected:
		UINT32
			cgReadModeBelowLimit, cgReadModeAboveLimit,
			cgWriteModeBelowLimit, cgWriteModeAboveLimit, 

			cgReadBreakLimit, cgWriteBreakLimit;

};
///////////////////////////////////////////////////////////////////////////////

class CPLXBoard: public CPCIBoard
{
	public:

		PPLXDevice cgpSIDev;
};

#ifdef SIDEF_PLX_C3x

class CPLXC33: public CPLXBoard
{
	public:

		INT32 ClassLoad ( UINT32 *param );
		INT32 ClassUnload ();

		INT32 
			CoffLoad
			(
				char filename[], UINT32 cgMemModule, UINT32 delay,
				UINT32 launch, UINT32 *coffImageSize
			);

		INT32 ResetBoard(UINT32 duration);

		INT32 Configure(UINT32 *params);

		INT32
			ReadFromBoard
			(
				UINT32 count, UINT32 addr, UINT32 *hostAddr
			);
		INT32
			WriteToBoard
			(
				UINT32 count, UINT32 addr, UINT32 *hostAddr
			);

		INT32
			ReadGeneric
			(
				UINT32 mode, UINT32 count, UINT32 addr, UINT32 *hostAddr
			);

		INT32
			WriteGeneric
			(
				UINT32 mode, UINT32 count, UINT32 addr, UINT32 *hostAddr
			);

		INT32 CoffQuListfromFile(char quListFilename[]);
		INT32 CloseQuListFileandLaunch(char quListFilename[]);

	INT32 CoffLoad_ConfigMemory(UINT32 *memoryConfig);
};

#endif //SIDEF_PLX_C3x
//
#endif	// vqhost_EXPORTS
*/

struct PLXC33{
	UINT32 cgReadModeBelowLimit;
	UINT32 cgReadModeAboveLimit;
	UINT32 cgWriteModeBelowLimit;
	UINT32 cgWriteModeAboveLimit;
	UINT32 cgReadBreakLimit;
	UINT32 cgWriteBreakLimit;
	struct PLXDevice *cgpSIDev;
//	struct PLXDevice cgpSIDev;
	UINT32	dataType;

	struct SI_BoardInfo boardInfo;
	struct SI_BoardInfo *pBoardInfo;

	//Used to switch between writing to a file or to a board
	UINT32	coffType;
	//filename
	char 	*quListFile;
	FILE	*quListfp;
	UINT32	savingQuListFile;
	UINT32  listSize;		 //used to compute the Pq/Vq list size.		
	UINT32	quListFileSize;
};

enum e_CommModes{
	e_CommModes_Invalid = -1
};

INT32 Conv_Float_Host2DSP(UINT32 size, float *dataIn, UINT32 *dataOut);
INT32 Conv_Float_DSP2Host(UINT32 size, UINT32 *dataIn, float *dataOut);


INT32 ClassLoad ( UINT32 *param );
INT32 ClassUnload ();

INT32 
	CoffLoad
	(
		char filename[], UINT32 cgMemModule, UINT32 delay,
		UINT32 launch, UINT32 *coffImageSize
	);

INT32 ResetBoard(UINT32 duration);

INT32 Configure(UINT32 *params);

INT32
	ReadFromBoard
	(
		UINT32 count, UINT32 addr, UINT32 *hostAddr
	);
INT32
	WriteToBoard
	(
		UINT32 count, UINT32 addr, UINT32 *hostAddr
	);

INT32
	ReadGeneric
	(
		UINT32 mode, UINT32 count, UINT32 addr, UINT32 *hostAddr
	);

INT32
	WriteGeneric
	(
		UINT32 mode, UINT32 count, UINT32 addr, UINT32 *hostAddr
	);

INT32 CoffQuListfromFile(char quListFilename[]);
INT32 CloseQuListFileandLaunch(char quListFilename[]);

INT32 CoffLoad_ConfigMemory(UINT32 *memoryConfig);
