///////////////////////////////////////////////////////////////////////////////
//	coffParse.h
//
//	Description:
//		Parses any and all COFF files and returns values that can be used to
//		download to the DSP. From external function, call ParseCoff.Then, it
//		returns the following.
//			- DSP address where the code should be loaded
//			- Number of words to load
//			- Data to load
//			- Number of sections to be loaded
//
//	Revision History:
//		2001-11-06: mik
//			Created.
//		2002-03-06: mik
//			Removed UINT8. basetsd.h from MS screws things up!
//		2002-04-17: mik
//			Shuffled #define paths to reflect directory changes.
//		2006-04-06: Whipple
//			Added coffOptions to ParseCoff()
//
///////////////////////////////////////////////////////////////////////////////
#if !defined(_COFFPARSE_H)
#define _COFFPARSE_H

#if defined(_cplusplus)
extern "C" {
#endif

#include "../common_ddk/sitypes.h"

////////////////////////////////////////////////////////////////////////////////

#define kCOFFFile_MaxBufferSize			4194304		// 4MB is max size for coff file
#define kCOFFFile_MaxNumberOfSections	1024    // maximum of 1024 loadable sections
#define kCOFFImage_MaxBufferSize		4194304		// 4MB is max size for resultant coff image

////////////////////////////////////////////////////////////////////////////////

#define STYP_REG	0x0000	//Regular section (allocated, relocated, loaded)
#define STYP_DSECT	0x0001	//Dummy section (relocated, not allocated, not 
							//	loaded)
#define STYP_NOLOAD	0x0002	//Noload section (allocated, relocated, not 
							//	loaded)
#define STYP_GROUP	0x0004	//Grouped section (formed from several input 
							//	sections)
#define STYP_PAD	0x0008 	//Padding section (loaded, not allocated, not 
							//	relocated)
#define STYP_COPY	0x0010 	//Copy section (relocated, loaded, but not 
							//	allocated; re-location and line-number 
							//	entries are processed normally)
#define STYP_TEXT	0x0020 	//Section that contains executable code
#define STYP_DATA	0x0040 	//Section that contains initialized data
#define STYP_BSS	0x0080 	//Section that contains uninitialized data
#define STYP_ALIGN	0x0700 	//Section that is aligned on a page boundary

////////////////////////////////////////////////////////////////////////////////

int ParseCoff
(
	char *filename, char *buffer, char *sectionNames[], UINT32 dspAddr[], 
	UINT32 size[], UINT32 *data[], UINT32 *loadableSections
);

int COFF_DebugWriteToFile
(
	char *coffFile, char *textFile
);

#if defined(_cplusplus)
}
#endif
#endif
