///////////////////////////////////////////////////////////////////////////////
//	SICodes.h
//
//	Description:
//		Following are SI Codes. They include:
//			- Reset status and values.
//			- Coff load options.
//
//	Revision History:
//		2001-08-24: mik
//			Created.
//		2001-11-06: mik
//			Added COFF parser error codes.
//		2002-02-20: mik
//			Added SDRAM error codes.
//		2002-04-12: mik
//			Added TranslateErrorCode function.
//		2002-04-17: mik
//			Moved error codes to SIErrors.h in SIDDK/common directory.
//		2002-05-01: mik
//			Added #if !defined(_SICODES_H).
//		2002-05-03: mik
//			Added e_DLL_RWType_Debug type to READ/WRITE.
//		2002-07-01: mik
//			Removed all VQHost specific defines to VQEnums.h.
//		2002-09-26: mik
//			Added blank line at the end.
//		2006-04-06: Whipple
//			Added BootMem coff load option
//			I probably hit tab and space somewhere too.
//			Cross your fingers
//		2007-03-11: Ley
//			Split and moved several files from VQHost level to SI-DDK level,
//			SI-DDK files kept original names while remaining kept VQ
//			prefix with VQ stuff:
//			board.h, camccc31.cpp, cboard.cpp, cisaboard1.cpp,
//			cplxc33.cpp, cplxc6711.cpp, cwin32dll.cpp, isadefs.h
//			cquxboard.h, cquxamccc31.cpp, cquxboard.cpp, cquxisaboard1.cpp,
//			cquxplxc33.cpp, cquxplxc6711.cpp, cquxwin32dll.cpp.
//			Replaced what were removed to VQEnums.h since they were
//			SI-DDK enums. VQEnums.h eliminated.
//
///////////////////////////////////////////////////////////////////////////////
#if !defined(_SICODES_H)
#define _SICODES_H

#if defined(_cplusplus)
extern "C" {
#endif

///////////////////////////////////////////////////////////////////////////////

enum e_Reset
{
	e_Reset_Assert	= 0,	// assert reset
	e_Reset_Deassert= 1,	// deassert reset (release, so DSP can run)
	e_Reset_Toggle	= 2,	// assert, then release reset
};

///////////////////////////////////////////////////////////////////////////////

enum e_CoffloadOptions
{
	e_Coffload_DSPInactive,	// DSP is not active. bootload or target mode
	e_Coffload_DSPActive	// DSP is active
};

///////////////////////////////////////////////////////////////////////////////

#define kMAXTIMEOUT_MS	10000	// timeout in msec

///////////////////////////////////////////////////////////////////////////////

enum e_OSType
{
	WIN95,
	WINNT
};

///////////////////////////////////////////////////////////////////////////////

enum e_HostBus 
{
	ISA, 
	AMCC, 
	PCMCIA, 
	PCIPLX9054, 
	PARALLELC6711, 
	WIN32DLL
};

////////////////////////////////////////////////////////////////////////////////

enum e_DSPType 
{
	C30, 
	C31, 
	C32, 
	C33, 
	C6711_75, 
	C6713_75, 
	C6713_66, 
	X86
};

///////////////////////////////////////////////////////////////////////////////

enum e_DSPBusClk
{
	_27MHz,
	_33MHz,
	_40MHz,
	_50MHz,
	_60MHz,
	_66MHz,
	_75MHz
};

///////////////////////////////////////////////////////////////////////////////

enum e_ISA_CommHandshake
{
	None,
	IORDY,
	TBC,
	Latch
};

enum e_ISA_TransferMode 
{
	Bits16,
	Bits32,
	DMA16,
	DMA32
};

enum e_ISA_PortWidth	   
{
	Port_Bits16,
	Port_Bits32
};

enum e_ISA_Memory_Module 
{
	Mem64K, Mem256K
};

/*todo:
enum e_ISA_Transfer_Direction 
{
	Read_Direction, Write_Direction
};
*/
///////////////////////////////////////////////////////////////////////////////

enum e_DLL_RWType
{
	e_DLL_RWType_Normal = 0, 
	e_DLL_RWType_Hostpoll,
	e_DLL_RWType_Debug
};

///////////////////////////////////////////////////////////////////////////////
enum e_RWMode_Generic
{
	e_CommModes_Generic_PCI_Target = 1, 
	e_CommModes_Generic_PCI_PLX_BMDMA,
	e_CommModes_Generic_PCI_Hostpoll, 
	e_CommModes_Generic_PCI_OpReg,
	e_CommModes_Generic_PCI_NVRAM 
};

/*
enum e_CommModes
{
	e_CommModes_Invalid = 0, 

	// C31 comm modes
	e_CommModes_AMCCC31_Target = 0x110,					// 1
	e_CommModes_AMCCC31_Point_Sync_IO_Target_CommReg,	// hostpoll
	e_CommModes_AMCCC31_Point_Sync_IO_OpReg_FIFO,
	e_CommModes_AMCCC31_Point_Async_IO_BM_FIFO,
	e_CommModes_AMCCC31_Point_Async_DMA_BM_FIFO,		// 5
	
	// C33. target and BMDMA and others.
	e_CommModes_PLXC33_Target = 0x120, 
	e_CommModes_PLXC33_BMDMA, 
	e_CommModes_PLXC33_Addon_Async_IO_Int, 
	e_CommModes_PLXC33_Addon_Async_DMA_Int, 
	e_CommModes_PLXC33_Point_Sync_IO_Target_CommReg,	// 10

	// C6711 always assumes DSP active comm. for target/BMDMA, use generic
	e_CommModes_PLXC6711_Addon_Async_IO_Int = 0x130, 
	e_CommModes_PLXC6711_Addon_Async_DMA_Int , 
	e_CommModes_PLXC6711_Point_Async_IO_Target_FIFO , 
	e_CommModes_PLXC6711_Point_DMA_BMDMA_FIFO , 
	e_CommModes_PLXC6711_Point_Sync_IO_Target_CommReg,
	e_CommModes_PLXC6711_Point_SDRAMDAIO,
	e_CommModes_PLXC6711_Point_SDRAMDABDMA
};
*/


struct SI_BoardInfo
{
	UINT32				boardID;			//PnP slot number
	UINT32				didVid[64];			//PCI VID_DID
	UINT32				cgDSP_DataSize;		//Address Boundary factor either 4B for C6x or 1DW for C3x

	enum e_DSPType			dspType;			//DSP Processor type either C3x or C6x
	enum e_DSPBusClk			dspBusClkIndex;		//Index for enumerating DSP external bus clock speed
	enum e_HostBus			cgHostBus;			//Host bus type either ISA or PCI
	UINT32				dspCoreClkSpeed;	//Internal DSP Core clock speed
	UINT32				dspBusClkSpeed;		//External Bus clock speed
	UINT32				cgDSP_Bank0; 		//Memory size are obtained only after CoffLoad
	UINT32				cgDSP_Bank1; 		//Memory size are obtained only after CoffLoad
};

///////////////////////////////////////////////////////////////////////////////
// Not used
/*
enum e_DaughterType 
{
	SI100, 
	DSP1600, 
	DSP6400
};

///////////////////////////////////////////////////////////////////////////////

enum e_DriverType
{
	e_Driver_AMCC_95,
	e_Driver_AMCC_NT, 
	e_Driver_AMCC_WDM,
	e_Driver_PLX9054_95,
	e_Driver_PLX9054_NT,
	e_Driver_PLX9054_WDM,
};

///////////////////////////////////////////////////////////////////////////////

enum e_MemType
{
	e_MemType_ISA_64k, 
	e_MemType_ISA_256k,
	e_MemType_PLXC33_128_0, 
};

///////////////////////////////////////////////////////////////////////////////
*/


#if defined(_cplusplus)
}
#endif
#endif
