///////////////////////////////////////////////////////////////////////////////
//	common_simod.h	: this is for SI daughter modules header .
//
//	Description:
//		Contains the defines for SI daughter modules such as
//		enums and structs that make up the mod struct used
//		to setup and configure SI daughter modules
//
//	Revision History:
//		2003-01-28: Colin
//			Created  
//		2004-08-16: Ley
//			Separated and modified from mod64.h
//
///////////////////////////////////////////////////////////////////////////////

//common Daughter Module defines
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#ifdef MOD68
#define kScaleFactor (float) (20 / pow(2, 16))
#define kDaughterNumDAC			16
#define kDaughterOffsetDAC		0x100        //32 bit boundary
#endif

#ifdef MOD64
#define kScaleFactor (float) (20 / pow(2, 16))
#define kDaughterNumDAC			4
#define kDaughterOffsetDAC		0x100        //32 bit boundary
#endif

//structs and enums used for DMOD struct
enum inputType
{
	singleA = 0,
	pos_Diff = 1,
	singleB = 2,
	neg_Diff = 3
};

enum diffGain
{
	dg_one = 0,
	dg_two = 1,
	dg_five = 2,
	dg_ten = 3
};

enum singleGain
{
	sg_one = 0,
	sg_ten = 1,
	sg_hudred = 2
};


typedef struct 
{
	enum inputType input;
	enum diffGain dg;
	enum singleGain sg;
}Channel;


typedef struct
{
	UINT16 DAC0_reset;
	UINT16 DAC1_reset;
	UINT16 DAC2_reset;
	UINT16 DAC3_reset;

	UINT16 DDS_reset;
	UINT16 DIO_dir;

	enum clockSource clksrc;

}MiscParam;

//function headers
INT32 read_AD
(
	struct PLXDevice *pPLXDev, int commMode, UINT32 data[64]
);

INT32 write_DAC
(
	struct PLXDevice *pPLXDev, int commMode, UINT32 dac_num, UINT32 *data,
	UINT32 daughterAddr, UINT32 daughterOffsetDAC, UINT32 maxDacs
);

INT32 write_DIO
(
	struct PLXDevice *pPLXDev, int commMode, UINT32 *data,
	UINT32 daughterAddr, UINT32 daughterOffsetDIO
);

INT32 SI_Read
(
	struct PLXDevice *pPLXDev, int commMode,
	UINT32 count, UINT32 dsp_addr, UINT32 *host_addr
);

INT32 SI_Write
(
	struct PLXDevice *pPLXDev, int commMode,
	UINT32 count, UINT32 dsp_addr, UINT32 *host_addr
);

INT32 SampleFrequencyComputation
(
	UINT32 ddsOutSampleRate,
	float refClockIn,
	UINT32 sampleRate,
	UINT32 paResolution,
	UINT32 *phaseAccumulatorArray,
	UINT32 *phseAccumulator,
	UINT32 *counterValue16bits
);

void Sample_WriteCalFiletoDSP(struct PLXDevice *pPLXDev, UINT32 commMode);

//UINT32 const kMaxCalFileSize = 0x4000;	// 16KB, ASCII file, which can be 1K
#define kMaxCalFileSize	0x4000
										// of data with 10 characters each.

void Sample_ReadADCsRAW(struct PLXDevice *pPLXDev, UINT32 commMode);

void Sample_ReadADCswCal(struct PLXDevice *pPLXDev, UINT32 commMode);

INT32 read_ADwCal(struct PLXDevice *pPLXDev, int commMode, UINT32 data[64]);

void Sample_WriteDACsRAW(struct PLXDevice *pPLXDev, UINT32 commMode);

void Sample_WriteDACswCal(struct PLXDevice *pPLXDev, UINT32 commMode);

INT32 write_DACwCal
(
	struct PLXDevice *pPLXDev, int commMode, UINT32 dac_num, float *data,
	UINT32 daughterAddr, UINT32 daughterOffsetDAC, UINT32 maxDACs
);

