///////////////////////////////////////////////////////////////////////////////
//	sicommon_plxc33.h
//
//	Description:
//		Common hardware access routines for PLX with C33. 
//		These calls are PLX C33 specific. In order to use the SI PLX board, 
//		only this header file is included in the project. This makes all PLX
//		and SI specific PLX call available (including bit file loading and 
//		coff parsing). See the sample program.
//
//	Revision History:
//		2002-03-04: mik
//			Created.
//		2002-03-18: mik
//			Modified and added FIFO based communications (DSP Active).
//		2002-04-17: mik
//			Shuffled #define paths to reflect directory changes.
//		2002-04-18: mik
//			Moved rudimentary addon-initiated to sicommon_plx.xxx.
//			Redefined target/bmdma (only byte boundary).
//		2002-06-25: mik
//			Changed comm mode to new method using bits.
//			Removed read/write CSR calls (not used).
//		2002-07-01: mik
//			Changed all instances of SIHW_ to SI_
//		2002-09-16: mik
//			Moved all pOverlapped and callback stuff into API.
//		2006-10-16: Ley
//			Expanded GetBoardInfo so now it also outputs
//			DSP Bus Speed and Boundary Factor.
//			For SISample related programs: Added read NVRam to have the DSP
//			Bus speed in order to calculate parameters for DDS
//			for Sampling Rate.
//		2007-07-13: Ley
//			Updated C33 for messaging, except for SetXferSize which
//			it doesn't use.
//
///////////////////////////////////////////////////////////////////////////////

#include "../../common/sihw_common_plx.h"	// common for all si plx boards

//#include "../../../../../../common_ddk/os_lnx.h"

#include <curses.h>
#include <sys/time.h>

///////////////////////////////////////////////////////////////////////////////
// Combination of Device ID and Vendor ID for C33

#define kDevice_DIDVID_C33_XL		0x101080bb
#define kDevice_DIDVID_C33_50e		0x101180bb
#define kDevice_DIDVID_C33			0x101280bb		// _100e ommited by Robert's Request.
#define kDevice_DIDVIDMask			0x000f0000

///////////////////////////////////////////////////////////////////////////////
//	C33 addresses as seen by DSP
//
//	All kPLXC33_CommReg are DWord addresses as seen from DSP

//	Starting offset for Communication Registers
#define kPLXC33_CommReg			0x30	
#define	kPLXC33_CommReg_Type	(kPLXC33_CommReg + 0x0 )
#define	kPLXC33_CommReg_Count	(kPLXC33_CommReg + 0x1 )
#define	kPLXC33_CommReg_AddrSrc	(kPLXC33_CommReg + 0x2 )
#define	kPLXC33_CommReg_AddrDst	(kPLXC33_CommReg + 0x3 )
#define	kPLXC33_CommReg_Flag	(kPLXC33_CommReg + 0x4 )
#define	kPLXC33_CommReg_Data	(kPLXC33_CommReg + 0x5 )

// not used						(kPLXC33_CommReg + 0x6)
// not used						(kPLXC33_CommReg + 0x7)

#define	kPLXC33_HostMessageFlag	(kPLXC33_CommReg + 0x8)
#define	kPLXC33_HostMessage		(kPLXC33_CommReg + 0x9)
#define	kPLXC33_DSPMessageFlag	(kPLXC33_CommReg + 0xA)
#define	kPLXC33_DSPMessage		(kPLXC33_CommReg + 0xB)


#define kPLXC33_SendMsgCommFlag	0x10
#define kPLXC33_SendMsgFlag	0x1
#define kPLXC33_RecvMsgFlag	0x1

#define kPLXC33_CommReg_HostAddr		0xC00000			

#define kPLXC33_CoffLoadOffset			0x00010000	//For C33, can be anywhere
													//just changing here
#define kPLXC33_TaskAddrTable			0x00004000
#define kPLXC33_gTaskAddr				0x00003E00
//	Following value can be 512 for C33, kept 128 in compatibility with C6711
#define kPLXC33_gTaskSize				128

#define kPLXC33_ResetVectorAddr			0x00000000

#define kPLXC33_DataSize				1
#define kPLXC33_COFF_BootRAMSize		524288	// 512KB is the Boot RAM size

#define kDaughterAddr			0xFE0000
#define CalAddr 			0x809800;	// IRAM0, Cal File address for C33
//UINT32 CalAddr = 0x809800;
#define kDSPBF					0x1 //dword addresses
#define kDSPClock				(75E6 / 2)


///////////////////////////////////////////////////////////////////////////////
//	See comments for SI_PLXC33_ConvertDSPAddress to see how the conversion 
//	is done. Note that these are DSP addresses as seen from the DSP side.
//	Equivalent PLX addresses are computed when these values are passed 
//	through SI_PLXC33_ConvertDSPAddress function.

#define kPLXC33_IntDSPAddr			0xFF0001 // 0x1F0001
#define	kPLXC33_IntDSPValue			(0x1)

//	These are registers. They can be write/read.
#define kPLXC33_CSRAddr				0xFF0000 // 0x1F0000
#define kPLXC33_CSRBit_Reset		0

///////////////////////////////////////////////////////////////////////////////
// Valid DSP Active communication modes.

/*
enum e_CommModeIdx
{
	e_CommModeIdx_Addon_Async_IO_Int = 0, 
	e_CommModeIdx_Addon_Async_DMA_Int,

	e_CommModeIdx_Point_Sync_IO_Target_CommReg
};
*/

enum e_CommModes_PLXC33
{
	// C33. target and BMDMA and others.
	e_CommModes_PLXC33_Target, 
	e_CommModes_PLXC33_BMDMA, 
	e_CommModes_PLXC33_Addon_Async_IO_Int, 
	e_CommModes_PLXC33_Addon_Async_DMA_Int, 
	e_CommModes_PLXC33_Point_Sync_IO_Target_CommReg,	// 10
};



///////////////////////////////////////////////////////////////////////////////
// Begin: Only for C33 PCI

INT32 SI_PLXC33_OpenDriver
(
	struct SI_BoardInfo *pBoardInfo, 
	struct PLXDevice *pPLXDev
);

INT32 SI_PLXC33_ResetBoard
(
	struct PLXDevice *pPLXDev, 
	UINT32 resetMode
);

/*
INT32 SI_PLXC33_ParseCoff
(
	struct PLXDevice *pPLXDev, char *filename, 
	UINT32 *dspMem, UINT32 dspMemCount, UINT32 *dspMemLoc, 
	UINT32 *wordsBeforeCoff, UINT32 *wordsAfterCoff, UINT32 *wordsAfterEnd
);
*/

INT32 SI_PLXC33_ParseCoff
(
	struct PLXDevice *pPLXDev, char *filename, UINT32 dspMemCount,
	UINT32 *passiveCoffImage, UINT32 *passiveCoffImageCount,
	UINT32 *activeCoffImage, UINT32 *activeCoffImageCount,
	UINT32 *wordsBeforeCoff
);

INT32 SI_PLXC33_CoffWrite
(
	struct PLXDevice *pPLXDev, char *filename, UINT32 coffOptions,
	UINT32 *coffImage, 	UINT32 coffImageCount
);

INT32 SI_PLXC33_CoffVerify
(
	struct PLXDevice *pPLXDev, char *filename, UINT32 coffOptions,
	UINT32 *coffImage, 	UINT32 coffImageCount
);


/*
INT32 SI_PLXC33_CoffLoad
(
	struct PLXDevice *pPLXDev, 
	char *filename, UINT32 coffOptions, 
	UINT32 *wordsBeforeCoff, UINT32 *wordsAfterCoff, UINT32 *wordsAfterEnd
);

INT32 SI_PLXC33_CoffVerify
(
	struct PLXDevice *pPLXDev, 
	char *filename, UINT32 coffOptions, 
	UINT32 *wordsBeforeCoff, UINT32 *wordsAfterCoff, UINT32 *wordsAfterEnd
);
*/

/*
INT32 SI_PLXC33_CoffLoad
(
	struct PLXDevice *pPLXDev, 
	char *filename, UINT32 coffOptions	
);

INT32 SI_PLXC33_CoffVerify
(
	struct PLXDevice *pPLXDev, 
	char *filename, UINT32 coffOptions	
);
*/

INT32 SI_PLXC33_ReadTarget
(
	struct PLXDevice *pPLXDev, 
	UINT32 region, UINT32 count, UINT32 dspAddr, UINT32 *hostAddr
);

INT32 SI_PLXC33_WriteTarget
(
	struct PLXDevice *pPLXDev, 
	UINT32 region, UINT32 count, UINT32 dspAddr, UINT32 *hostAddr
);

INT32 SI_PLXC33_ReadBlockDMA
(
	struct PLXDevice *pPLXDev, 
	UINT32 count, UINT32 dspAddr, UINT32 *hostAddr
);

INT32 SI_PLXC33_WriteBlockDMA
(
	struct PLXDevice *pPLXDev, 
	UINT32 count, UINT32 dspAddr, UINT32 *hostAddr
);

INT32 SI_PLXC33_ReadHostpoll
(
	struct PLXDevice *pPLXDev, 
	UINT32 count, UINT32 dspAddr, UINT32 *hostAddr
);

INT32 SI_PLXC33_WriteHostpoll
(
	struct PLXDevice *pPLXDev, 
	UINT32 count, UINT32 dspAddr, UINT32 *hostAddr
);

INT32 SI_PLXC33_ReadDSPActive
(
	struct PLXDevice *pPLXDev, 
	UINT32 commModeIndex, UINT32 count, UINT32 dspAddr, UINT32 *hostAddr
);

INT32 SI_PLXC33_WriteDSPActive
(
	struct PLXDevice *pPLXDev, 
	UINT32 commModeIndex, UINT32 count, UINT32 dspAddr, UINT32 *hostAddr
);

INT32 SI_PLXC33_TranslateCommModeIndex
(
	UINT32 commModeIndex, UINT32 *commMode, 
	UINT32 maxStringCount, char *commName
);

INT32 SI_PLXC33_CoffLoad_GetMemoryParams
(
	struct PLXDevice *pPLXDev, UINT32 *memoryParams
);

INT32 SI_PLXC33_RecvMessage
(
	struct PLXDevice *pPLXDev, INT32 waitMilliSecs, UINT32 *msg
);

INT32 SI_PLXC33_SendMessage
(
	struct PLXDevice *pPLXDev, INT32 waitMilliSecs, UINT32 msg
);

INT32 SI_PLXC33_CommInterrupt
(
	struct PLXDevice *pPLXDev
);
