///////////////////////////////////////////////////////////////////////////////
//	sisample.h	: this is the filename Sheldon Instruments sample Program.
//	sample.h	: this is the filename for SIDDK only sample program. 
//
//	Description:
//		Contains common files for command prompt sample program. 
//		As long as ghDevice is initialized to be the handle to SIDDK driver, 
//		these calls should work with WIN95, NT4, WDM.
//
//	Revision History:
//		2002-06-11: Av&Ley
//			Created sample program for SIDDK
//		2003-06-19: mik
//			Added Sample_DSPInitiated_Access.
///////////////////////////////////////////////////////////////////////////////

#ifndef SIDEF_PLX_C671x
#ifndef SIDEF_PLX_C3x
#ifndef SIDEF_PLX_SIDDK
//	no build environmemt specified
#endif
#endif
#endif

#include "../c33/common/sicommon_plxc33.h"
#include "../../../../../common_ddk/os_lnx.h"
//extern INT32 OS_Popup_ErrorMessageBox(char *text, char *caption, int errorCode, UINT32 type);
#define kMENU	"\n\
===========================================================================\n\
    PLX MENU\n\
\n\
 1  Write Mailbox Register\n\
 2  Read Mailbox Register\n\
 3  Read Configuration Space\n\
 4  Write to OpReg (Local Config, Runtime, DMA, Message Queue)\n\
 5  Read from OpReg (Local Config, Runtime, DMA, Message Queue)\n\
 6  BusMaster Write (Ramp Pattern using Block DMA - DSP in Reset)\n\
 7  BusMaster Read (Block DMA - DSP in Reset)\n\
 8  Target Write (DSP in Reset)\n\
 9  Target Read (DSP in Reset)\n\
 A  Write NvRam\n\
 B  Read NvRam\n\
 C  Set Busmastered Timeout\n\
 D  Direct Access\n\
 E  Change Point/Block mode\n\
---------------------------------------------------------------------------\n\
    C33 MENU\n\
\n\
 F  Configure FPGA\n\
 G  Load Coff File\n\
 H  DSP Communications\n\
---------------------------------------------------------------------------\n\
 M  SI-MODULE MENU\n\
---------------------------------------------------------------------------\n\
 0  Exit DriverDemo\n\
===========================================================================\n\
Enter Selection: "

///////////////////////////////////////////////////////////////////////////////

void Sample_MainCommandLoop();

void Sample_WriteMailboxRegister();
void Sample_ReadMailboxRegister();
void Sample_ReadConfigurationSpace();
void Sample_WriteOpReg();
void Sample_ReadOpReg();
void Sample_WriteBusmastered();
void Sample_ReadBusmastered();
void Sample_WriteTarget();
void Sample_ReadTarget();
void Sample_WriteNVRAM();
void Sample_ReadNVRAM();
void Sample_SetTimeout();
void Sample_DirectAccess(UINT32 *dirAccessAddr[]);
void Sample_DriverConfigPointBlock();
void Sample_AddonInit();
void GetAddonAddress(UINT32 *);
void Sample_ReadBus200();

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
//	Following are specific to SI board. Do not use them for non SI boards.
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

#define SIDEF_PLX_C3xC671x

#ifdef SIDEF_PLX_C3xC671x
#define kGetAddress_HostView	1
#define kGetAddress_DSPView		2

///////////////////////////////////////////////////////////////////////////////
void Sample_LoadCofffile();
void Sample_DSPComm();
void Sample_ConfigureFPGA();
void PrintAvailableAddresss(int);
#endif

///////////////////////////////////////////////////////////////////////////////
