///////////////////////////////////////////////////////////////////////////////
//	sisamplib.h
//
//	Description:
//		Common files for sample DLL program for PLX C6711
//
//	Revision History:
//		2002-03-07: mik
//			Created.
//		2002-03-19: mik
//			Renamed AddonInit to DSPActiveComm.
//		2002-04-12: mik
//			Added Sample_TranslateErrorCode function.
//		2002-04-17: mik
//			Moved into sisamplib directory since it can now use all drivers.
//		2002-04-18: mik
//			Moved rudimentary addon-initiated to sicommon_plx.xxx.
//			Redefined target/bmdma (only byte boundary).
//			Restructured so that it's easy to move from sisample to sample.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef SIDEF_PLX_C671x
#ifndef SIDEF_PLX_C3x
#ifndef SIDEF_PLX_SIDDK
	no build environmemt specified
#endif
#endif
#endif

#include <stdio.h>

#ifdef SIDEF_PLX_C671x
#include "../c6711pci/common/sicommon_plxc6711.h"
#endif

#ifdef SIDEF_PLX_SIDDK
#include "../../../siddk/90xx/common/sicommon_plx.h"
#endif

#ifdef SIDEF_PLX_C3x
#include "../c33/common/sicommon_plxc33.h"
#endif

//#ifdef WIN32
//#include "..\..\..\..\..\common_ddk\os_win.h"
//extern HANDLE gModule;
//#endif

//#ifdef LINUX
//#include "../../../../../common_ddk/os_lnx.h"
//#endif

///////////////////////////////////////////////////////////////////////////////
#ifdef WIN32
#define DLLReturnType __declspec(dllexport) INT32 WINAPI
#endif

#ifdef LINUX
#define DLLReturnType INT32
#endif

///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// All these are SO exported functions. This means these function names will 
//	be used by external program. If these functions are C++, then their names
//	will be mangled by the compiler. C++ mangles the name by appending type
//	and other info in the function names during compile/link. Since we have
//	no complete control over C++ function name mangling, we cast these
//	exported functions to be C functions to preserve their names.

extern "C"
{

bool SI_DLL_Entry();
int SI_DLL_Exit();

DLLReturnType  
Sample_WriteMailboxRegister
(
	INT32 board, 
	UINT32 mailboxNum, 
	UINT32 *data
);

DLLReturnType  
Sample_ReadMailboxRegister
(
	INT32 board, 
	UINT32 mailboxNum, 
	UINT32 *data
);

DLLReturnType  
Sample_ReadConfigurationSpace
(
	INT32 board, 
	UINT32 count, 
	UINT32 offset, 
	UINT32 *data
);

DLLReturnType  
Sample_WriteOpReg
(
	INT32 board, 
	UINT32 opRegNum, 
	UINT32 *data
);

DLLReturnType  
Sample_ReadOpReg
(
	INT32 board, 
	UINT32 opRegNum, 
	UINT32 *data
);

DLLReturnType  
Sample_WriteBusmastered
(
	INT32 board, 
	UINT32 count, 
	UINT32 offset, 
	UINT32 *data
);

DLLReturnType  
Sample_ReadBusmastered
(
	INT32 board, 
	UINT32 count, 
	UINT32 offset, 
	UINT32 *data
);

#ifdef SIDEF_PLX_SIDDK

DLLReturnType  
Sample_WriteTarget8
(
	INT32 board, 
	UINT32 region,
	UINT32 count, 
	UINT32 offset, 
	UINT8 *data
);

DLLReturnType  
Sample_WriteTarget16
(
	INT32 board, 
	UINT32 region,
	UINT32 count, 
	UINT32 offset, 
	UINT16 *data
);

DLLReturnType  
Sample_ReadTarget8
(
	INT32 board, 
	UINT32 region, 
	UINT32 count, 
	UINT32 offset, 
	UINT8 *data
);

DLLReturnType  
Sample_ReadTarget16
(
	INT32 board, 
	UINT32 region, 
	UINT32 count, 
	UINT32 offset, 
	UINT16 *data
);

#endif

DLLReturnType  
Sample_WriteTarget
(
	INT32 board, 
	UINT32 region,
	UINT32 count, 
	UINT32 offset, 
	UINT32 *data
);

DLLReturnType  
Sample_ReadTarget
(
	INT32 board, 
	UINT32 region, 
	UINT32 count, 
	UINT32 offset, 
	UINT32 *data
);

DLLReturnType  
Sample_WriteNVRAM
(
	INT32 board, 
	UINT32 addrNVRam, 
	UINT32 *data
);

DLLReturnType  
Sample_ReadNVRAM
(
	INT32 board, 
	UINT32 addrNVRam, 
	UINT32 *data
);

DLLReturnType  
Sample_SetTimeout
(
	INT32 board, 
	UINT32 milliseconds
);

DLLReturnType  
Sample_CancelBusmastering
(
	INT32 board
);

DLLReturnType  
Sample_GetBaddr
(
	INT32 board, 
	UINT32 *dirAddr[]
);

DLLReturnType  
Sample_ReleaseBaddr
(
	INT32 board
);

DLLReturnType  
Sample_DriverConfigPointBlock
(
	INT32 board, UINT32 pointOrBlock
);

DLLReturnType  
Sample_TranslateErrorCode
(
	int error, char errorMsg[]
);

// Begin: For sample program demo only.

DLLReturnType  
Sample_ReadAddonInit
(
	INT32 board, 
	UINT32 count, 
	UINT32 dspAddr, 
	UINT32 *hostAddr, 
	UINT32 mode
);

DLLReturnType  
Sample_WriteAddonInit
(
	INT32 board, 
	UINT32 count, 
	UINT32 dspAddr, 
	UINT32 *hostAddr, 
	UINT32 mode
);

DLLReturnType  
Sample_CONV_FLOAT_DSP2HOST
(
	INT32 boardID,
	UINT32 size,
	UINT32 *dataIn,				// DSP format
	float *dataOut				// Host format.
);

DLLReturnType  
Sample_CONV_FLOAT_HOST2DSP
(
	INT32 boardID,
	UINT32 size,
	float *dataIn,				// Host format
	UINT32 *dataOut				// DSP format.
);

// End: For sample program demo only.

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
//	Following are specific to SI board. Do not use them for non SI boards.
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
// Begin: Used only by SI boards.

#ifdef SIDEF_PLX_C671x
#define SIDEF_PLX_C3xC671x
#endif

#ifdef SIDEF_PLX_C3x
#define SIDEF_PLX_C3xC671x
#endif

#ifdef SIDEF_PLX_C3xC671x

DLLReturnType  
Sample_LoadCofffile
(
	INT32 board, 
	char filename[], 
	UINT32 coffOptions
);

DLLReturnType  
Sample_ReadDSPActiveComm
(
	INT32 board, 
	UINT32 count, 
	UINT32 dspAddr, 
	UINT32 *hostAddr, 
	UINT32 mode
);

DLLReturnType  
Sample_WriteDSPActiveComm
(
	INT32 board, 
	UINT32 count, 
	UINT32 dspAddr, 
	UINT32 *hostAddr, 
	UINT32 mode
);

DLLReturnType  
Sample_ResetBoard
(
	INT32 board,
	UINT32 resetMode
);

DLLReturnType  
Sample_ConfigureFPGA
(
	INT32 board,
	char filename[]
);

#endif

#ifdef SIDEF_PLX_C671x

DLLReturnType  
Sample_ReadSDRAMEEPROM
(
	INT32 board,
	UINT32 *data
);

#endif
// End: Used only by SI boards.

}
