///////////////////////////////////////////////////////////////////////////////
//	sicommon_plx_types.h
//
//	Description:
//		Types used by SI PLX DDK.
//
//	Revision History:
//		2002-08-08: mik
//			Created for windows.
//		2002-09-25: mik
//			Added Linux definitions.
//		2003-06-04: mik
//			Made it work with DOS "driver".
//		2006-10-16: Ley
//			Expanded GetBoardInfo so now it also outputs
//			DSP Bus Speed and Boundary Factor.
//			For SISample related programs: Added read NVRam to have the DSP
//			Bus speed in order to calculate parameters for DDS
//			for Sampling Rate.
//		2006-01-30: Madrid
//			Added PLXDev memebers to Linux
//

#ifndef _SICOMMON_PLX_TYPES_H
#define _SICOMMON_PLX_TYPES_H

#if defined(_cplusplus)
extern "C" {
#endif

// types used by SI must come after OS specific defines.
#include <signal.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include "../../common_ddk/sitypes.h"		

#ifndef NULL
#define NULL	0
#endif

#define EVENT_MSG_TYPE		0x200
#define EVENT_CALL_TYPE		0x400

struct msgBuf { 
       long    msgType;  

       char    msgText[1];

}; 


struct PLXDevice
{
	int		hDevice;
	UINT32	*addonInitPointer;
	UINT32	addonInitBufferSize;
	struct 	sigaction callback;
	
	struct  msgBuf eventMsg[1];
	struct  msgBuf eventCall[1];
	int		msgID;
	int		callID;
	
	int		wait_event;
	int		message_event;

	UINT32	paramPLL[2];	//Exclusive for C6711, moved to CPLXC6711

};

///////////////////////////////////////////////////////////////////////////////
#if defined(_cplusplus)
}
#endif
#endif //_SICOMMON_PLX_TYPES_H
