////////////////////////////////////////////////////////////////////////////////
//	busmaster_ver_0204.c
//
//	Description:
//		busmaster for plx		
//	Rev Notes:
//		2001-11-01: Colin
//			Created.
//		2002-11-25: Colin
//			Added SG DMA
//

#include "../main.h"
////////////////////////////////////////////////////////////////////////////////
//	int SIPLX_doBlockDMA_Read
//
//	Description:
//
//	Parameters:
//	int board_num, 
//	ulong dspaddr, ulong hostaddr, ulong count,
//	int new
//
//	Return Values:
//	int 

int SIPLX_doBlockDMA_Read
(
	int board_num, 
	ulong dspaddr, ulong hostaddr, ulong count,
	int new
)
{
	struct kiobuf *iobuf;
	struct descrpt tscrpt;
	struct transfer_info *transfer_info = NULL;
	ulong intcsr_reg;
	ulong dmamode_reg;
	ulong dmamodeAddress;
	ulong dmapadrAddress;
	ulong dmaladrAddress;
	ulong dmasizAddress;
	ulong dmadprAddress;
	ulong enableBit;
	ulong startBit;
	ulong interruptBit;
	ulong dmacsrAddress;

	ulong pgoffset;
	u32 localaddr;
	
	ulong iosize, result, i;
	ulong offset, remain, max_size;
	ulong startAddr, localbusAddr, dmadprstuff;
	
	SIprintk0((kModuleName "-SIPLX_doBlockDMA: Entering\n"));

	
	if (new == TRUE)
		while 
		(
			pdx[board_num].readtransfer.in_progress 
		);

	count *= 4;


	//Debug - used to generate multiple interrupts
	
	max_size = DSIZE;

	iosize = max_size;
	remain = hostaddr & PAGE_MASK;
	remain = hostaddr - remain;
	iosize -= remain;			

	if(iosize > count)
		iosize = count;

	if 
	(
		!pdx[board_num].readtransfer.setup 
	)
	{
	
		// Setup Timer
		if (pdx[board_num].readtransfer.timer_value)
		{
			init_timer(&pdx[board_num].readtransfer.time_out);
			pdx[board_num].readtransfer.time_out.function = SIPLX_read_time_out;
			pdx[board_num].readtransfer.time_out.data = board_num;
			pdx[board_num].readtransfer.time_out.expires = jiffies +
				(pdx[board_num].readtransfer.timer_value * HZ);

			add_timer(&pdx[board_num].readtransfer.time_out);
		}
		
		//transfer in progress
			pdx[board_num].readtransfer.in_progress = TRUE;

		pdx[board_num].readtransfer.loop = 0;

		//get number of kiobufs 
		pdx[board_num].readtransfer.nr_buf = count/max_size;
		if(count%max_size)
			pdx[board_num].readtransfer.nr_buf += 1;
		if((max_size - (count%max_size)) < remain)
			pdx[board_num].readtransfer.nr_buf += 1;
		if(((count%max_size) == 0) && remain)
			pdx[board_num].readtransfer.nr_buf += 1;
		
		result = SI_Alloc_Kiobuf
			(
				pdx[board_num].readtransfer.iobuf, 
				pdx[board_num].readtransfer.nr_buf
			);
		if (!result)
		{
			SIprintk0((kModuleName "-SIPLX_doBlockDMA: error alloc\n"));
			return -ENOMEM;
		}

		remain = 0;
		for (i = 0; i < pdx[board_num].readtransfer.nr_buf; i++)
		{

			offset = iosize;
			if 
			(
				(i == (pdx[board_num].readtransfer.nr_buf - 1)) 
			)
					offset = count - remain;
			
			result = map_user_kiobuf
				(
					READ, 
					pdx[board_num].readtransfer.iobuf[i], 
					hostaddr + (remain),
					offset
				);
			if(result) 
			{
				SIprintk0(
					(kModuleName 
					"-SIPLX_doBlockDMA:error on map iter: %d\n",
					i
					));
				//from free_kiovec and kern 2.5
				SI_Free_Kiovec(pdx[board_num].readtransfer.iobuf, i);
				return result;
			}
			remain += offset;

			iosize = max_size;
			if(iosize > count)
				iosize = count;
		}
		result = lock_kiovec
			(
				pdx[board_num].readtransfer.nr_buf, 
				pdx[board_num].readtransfer.iobuf, 
				1
			);
		if (result != 0)
		{
			for (i = 0; i < pdx[board_num].readtransfer.nr_buf; i++)
				unmap_kiobuf(pdx[board_num].readtransfer.iobuf[i]);
			SI_Free_Kiovec(pdx[board_num].readtransfer.iobuf, i);
			return result;
		}
		max_size = DSIZE;

		iosize = max_size;
		remain = hostaddr & PAGE_MASK;
		remain = hostaddr - remain;
		iosize -= remain;				

		if(iosize > count)
			iosize = count;

	}
	
	iobuf =	pdx[board_num].readtransfer.iobuf[pdx[board_num].readtransfer.loop];

	pgoffset = iobuf->offset;
	offset = PAGE_SIZE - iobuf->offset;
	if (offset > iosize)
		offset = iosize;

	localaddr = dspaddr;

		//quad word align 
		pdx[board_num].readtransfer.Descriptor = (struct descrpt*)
			(((ulong)pdx[board_num].dma.rpdscrpt + 0xf)& ~0xf);
		//build transfer list
		for (i=0; i < (iobuf->nr_pages); i++)
		{
			tscrpt.pciaddr = (page_to_bus(iobuf->maplist[i]) + pgoffset);
			pgoffset = 0;
			tscrpt.localaddr = localaddr;
			localaddr += offset;
			tscrpt.size = offset;
			offset = PAGE_SIZE;

			tscrpt.next =
				__pa(&(pdx[board_num].readtransfer.Descriptor[i+1].pciaddr));
				tscrpt.next |= PLX_READ | PLX_PCI;

			pdx[board_num].readtransfer.Descriptor[i] = tscrpt;
		}
		pdx[board_num].readtransfer.Descriptor[i-1].next = 0x00000000;
		pdx[board_num].readtransfer.Descriptor[i-1].next |= PLX_EOC | PLX_READ | PLX_PCI;
		if (iosize > (PAGE_SIZE - iobuf->offset))
		{
			offset = iosize - (PAGE_SIZE - iobuf->offset);
			offset =  offset % PAGE_SIZE;
			if (offset)
				pdx[board_num].readtransfer.Descriptor[i-1].size = offset;
		}

		pdx[board_num].readtransfer.user_addr = hostaddr + iosize;
		pdx[board_num].readtransfer.local_addr = dspaddr + iosize;
		pdx[board_num].readtransfer.bytes_requested = iosize;
		pdx[board_num].readtransfer.bytes_remaining = count - iosize;
		transfer_info = &pdx[board_num].readtransfer;

		dmamodeAddress = 
			pdx[board_num].mem[PLX_OPREGS].base_addr + (PLX_DMAMODE1 * 4);

		dmapadrAddress = 
			pdx[board_num].mem[PLX_OPREGS].base_addr + (PLX_DMAPADR1 * 4);
			
		dmaladrAddress = 
			pdx[board_num].mem[PLX_OPREGS].base_addr + (PLX_DMALADR1 * 4);
			
		dmasizAddress  = 
			pdx[board_num].mem[PLX_OPREGS].base_addr + (PLX_DMASIZ1 * 4);
			
		dmadprAddress  = 
			pdx[board_num].mem[PLX_OPREGS].base_addr + (PLX_DMADPR1 * 4);
		enableBit      = 0x1;
		startBit       = 0x2;
		interruptBit   = PLX_DMA1IE;
		dmacsrAddress = pdx[board_num].mem[PLX_OPREGS].base_addr + PLX_DMACSR1;
		startAddr =
			transfer_info->Descriptor[0].pciaddr;
		if (iosize > (PAGE_SIZE - iobuf->offset))
		dmadprstuff =
		(__pa(&pdx[board_num].readtransfer.Descriptor[0].pciaddr) | PLX_READ | PLX_PCI);
		else	
		dmadprstuff = 
			pdx[board_num].readtransfer.Descriptor[0].next;
		localbusAddr = 
			transfer_info->Descriptor[0].localaddr;

	// Disable interrupts
	intcsr_reg = 
		readl
		(
			pdx[board_num].mem[PLX_OPREGS].base_addr + (PLX_INTCSR * 4)
		);
	intcsr_reg &= ~interruptBit;
	writel
	(
		intcsr_reg,
		pdx[board_num].mem[PLX_OPREGS].base_addr + (PLX_INTCSR * 4)
	);

	// Set up DMA registers
	writel( startAddr, dmapadrAddress );
	writel( localbusAddr, dmaladrAddress );
	writel( transfer_info->Descriptor[0].size, dmasizAddress );
	writel( dmadprstuff, dmadprAddress);

	// Set DMA mode
	dmamode_reg = 0;
	dmamode_reg |= (transfer_info->demandMode ? PLX_DEMAND : PLX_LOCBURS);
	dmamode_reg |= PLX_TARDY;
	dmamode_reg |= PLX_32BIT | PLX_DINT | PLX_PCIINT | PLX_SCATTER;

	if 
	(
		pdx[board_num].driverConfig.blockPoint 
		== SI_CONFIGDRIVER_TRANSFERPOINT
	)
	{
		for (i=0; i < iobuf->nr_pages; i++)
			transfer_info->Descriptor[i].localaddr = dspaddr;		

		pdx[board_num].readtransfer.local_addr = dspaddr;
		pdx[board_num].writetransfer.local_addr = dspaddr;

		dmamode_reg |= PLX_LOCINC;
	}
	
	writel(dmamode_reg, dmamodeAddress);

	SIprintk1
	((
		kModuleName "-SIPLX_doBlockDMA: "
		"dmamode_reg=0x%lx", 
		dmamode_reg
	));
		

	// Enable interrupts
	intcsr_reg = 
		readl
		(
			pdx[board_num].mem[PLX_OPREGS].base_addr + (PLX_INTCSR * 4)
		);
	intcsr_reg |= PLX_LIIE | PLX_PCIIE | interruptBit;
	
	writel
	(
		intcsr_reg, 
		pdx[board_num].mem[PLX_OPREGS].base_addr + (PLX_INTCSR * 4)
	);
	
	// Start DMA 
	writeb(enableBit, dmacsrAddress);
	writeb(enableBit | startBit, dmacsrAddress);

	SIprintk0((kModuleName "-SIPLX_doBlockDMA: Exiting\n"));

	return 0;		
}

////////////////////////////////////////////////////////////////////////////////
//	int SIPLX_doBlockDMA_Write
//
//	Description:
//
//	Parameters:
//	int board_num, 
//	ulong dspaddr, ulong hostaddr, ulong count,
//	int new
//
//	Return Values:
//	int 

int SIPLX_doBlockDMA_Write
(
	int board_num, 
	ulong dspaddr, ulong hostaddr, ulong count,
	int new
)
{
	struct kiobuf *iobuf;
	struct descrpt tscrpt;
	struct transfer_info *transfer_info = NULL;
	ulong intcsr_reg;
	ulong dmamode_reg;
	ulong dmamodeAddress;
	ulong dmapadrAddress;
	ulong dmaladrAddress;
	ulong dmasizAddress;
	ulong dmadprAddress;
	ulong enableBit;
	ulong startBit;
	ulong interruptBit;
	ulong dmacsrAddress;

	ulong pgoffset;
	u32 localaddr;
	
	ulong iosize, result, i;
	ulong offset, remain, max_size;
	ulong startAddr, localbusAddr, dmadprstuff;
	
	SIprintk0((kModuleName "-SIPLX_doBlockDMA: Entering\n"));

	
	if (new == TRUE)
		while 
		(
			pdx[board_num].writetransfer.in_progress
		);

	count *= 4;


	//Debug - used to generate multiple interrupts
	
	max_size = DSIZE;

	iosize = max_size;
	remain = hostaddr & PAGE_MASK;
	remain = hostaddr - remain;
	iosize -= remain;			

	if(iosize > count)
		iosize = count;

	if 
	(
		!pdx[board_num].writetransfer.setup
	)
	{
	
		// Setup Timer
		if(pdx[board_num].writetransfer.timer_value)
		{
			init_timer(&pdx[board_num].writetransfer.time_out);
			pdx[board_num].writetransfer.time_out.function = SIPLX_write_time_out;
		
			pdx[board_num].writetransfer.time_out.data = board_num;
			pdx[board_num].writetransfer.time_out.expires = jiffies +
				(pdx[board_num].writetransfer.timer_value * HZ);

			add_timer(&pdx[board_num].writetransfer.time_out);
		}
		
		//transfer in progress
		pdx[board_num].writetransfer.in_progress = TRUE;

		pdx[board_num].writetransfer.loop = 0;

		//get number of kiobufs 
		pdx[board_num].writetransfer.nr_buf = count/max_size;
		if(count%max_size)
			pdx[board_num].writetransfer.nr_buf += 1;
		if((max_size - (count%max_size)) < remain)
			pdx[board_num].writetransfer.nr_buf += 1;
		if(((count%max_size) == 0) && remain)
			pdx[board_num].writetransfer.nr_buf += 1;
		
		result = SI_Alloc_Kiobuf
			(
				pdx[board_num].writetransfer.iobuf, 
				pdx[board_num].writetransfer.nr_buf
			);
		if (!result)
		{
			SIprintk0((kModuleName "-SIPLX_doBlockDMA: error alloc\n"));
			return -ENOMEM;
		}

		remain = 0;
		for (i = 0; i < pdx[board_num].writetransfer.nr_buf; i++)
		{

			offset = iosize;
			if 
			(
				(i == (pdx[board_num].writetransfer.nr_buf - 1)) 
			)
					offset = count - remain;
			
			result = map_user_kiobuf
				(
					READ, 
					pdx[board_num].writetransfer.iobuf[i], 
					hostaddr + (remain),
					offset
				);
			if(result) 
			{
				SIprintk0(
					(kModuleName 
					"-SIPLX_doBlockDMA:error on map iter: %d\n",
					i
					));
				//from free_kiovec and kern 2.5
				SI_Free_Kiovec(pdx[board_num].writetransfer.iobuf, i);
				return result;
			}
			remain += offset;

			iosize = max_size;
			if(iosize > count)
				iosize = count;
		}
		result = lock_kiovec
			(
				pdx[board_num].writetransfer.nr_buf, 
				pdx[board_num].writetransfer.iobuf, 
				1
			);
		if (result != 0)
		{
			for (i = 0; i < pdx[board_num].writetransfer.nr_buf; i++)
				unmap_kiobuf(pdx[board_num].writetransfer.iobuf[i]);
			SI_Free_Kiovec(pdx[board_num].writetransfer.iobuf, i);
			return result;
		}
		max_size = DSIZE;

		iosize = max_size;
		remain = hostaddr & PAGE_MASK;
		remain = hostaddr - remain;
		iosize -= remain;				

		if(iosize > count)
			iosize = count;

	}
	
	iobuf =	pdx[board_num].writetransfer.iobuf[pdx[board_num].writetransfer.loop];

	pgoffset = iobuf->offset;
	offset = PAGE_SIZE - iobuf->offset;
	if (offset > iosize)
		offset = iosize;

	localaddr = dspaddr;
		//quad word align 
		pdx[board_num].writetransfer.Descriptor = (struct descrpt*)
			(((ulong)pdx[board_num].dma.wpdscrpt + 0xf)& ~0xf);
		//build transfer list
		for (i=0; i < iobuf->nr_pages; i++)
		{
			tscrpt.pciaddr = (page_to_bus(iobuf->maplist[i]) + pgoffset);
			pgoffset = 0;
			tscrpt.localaddr = localaddr;
			localaddr += offset;
			tscrpt.size = offset;
			offset = PAGE_SIZE;

			tscrpt.next =
				__pa(&(pdx[board_num].writetransfer.Descriptor[i+1].pciaddr));
				tscrpt.next |= PLX_WRITE | PLX_PCI;

			pdx[board_num].writetransfer.Descriptor[i] = tscrpt;
		}
		pdx[board_num].writetransfer.Descriptor[i-1].next = 0x00000000;
		pdx[board_num].writetransfer.Descriptor[i-1].next |= PLX_EOC | PLX_WRITE | PLX_PCI;
		if (iosize > (PAGE_SIZE - iobuf->offset))
		{
			offset = iosize - (PAGE_SIZE - iobuf->offset);
			offset =  offset % PAGE_SIZE;
			if (offset)
				pdx[board_num].writetransfer.Descriptor[i-1].size = offset;
		}
		
		pdx[board_num].writetransfer.user_addr = hostaddr + iosize;
		pdx[board_num].writetransfer.local_addr = dspaddr + iosize;
		pdx[board_num].writetransfer.bytes_requested = iosize;
		pdx[board_num].writetransfer.bytes_remaining = count - iosize;
		transfer_info = &pdx[board_num].writetransfer;
		
		dmamodeAddress = 
			pdx[board_num].mem[PLX_OPREGS].base_addr + (PLX_DMAMODE0 * 4);
			
		dmapadrAddress = 
			pdx[board_num].mem[PLX_OPREGS].base_addr + (PLX_DMAPADR0 * 4);
			
		dmaladrAddress = 
			pdx[board_num].mem[PLX_OPREGS].base_addr + (PLX_DMALADR0 * 4);
			
		dmasizAddress  = 
			pdx[board_num].mem[PLX_OPREGS].base_addr + (PLX_DMASIZ0 * 4);
			
		dmadprAddress  = 
			pdx[board_num].mem[PLX_OPREGS].base_addr + (PLX_DMADPR0 * 4);
			
		enableBit      = 0x1;
		startBit       = 0x2;
		interruptBit   = PLX_DMA0IE;
		dmacsrAddress = pdx[board_num].mem[PLX_OPREGS].base_addr + PLX_DMACSR0;
		startAddr =
			transfer_info->Descriptor[0].pciaddr;
		if (iosize > (PAGE_SIZE - iobuf->offset))
		dmadprstuff =
		(__pa(&pdx[board_num].writetransfer.Descriptor[0].pciaddr)
		| PLX_WRITE | PLX_PCI);
		else	
		dmadprstuff = 
			pdx[board_num].writetransfer.Descriptor[0].next;
		localbusAddr = 
			transfer_info->Descriptor[0].localaddr;

	// Disable interrupts
	intcsr_reg = 
		readl
		(
			pdx[board_num].mem[PLX_OPREGS].base_addr + (PLX_INTCSR * 4)
		);
	intcsr_reg &= ~interruptBit;
	writel
	(
		intcsr_reg,
		pdx[board_num].mem[PLX_OPREGS].base_addr + (PLX_INTCSR * 4)
	);

	// Set up DMA registers
	writel( startAddr, dmapadrAddress );
	writel( localbusAddr, dmaladrAddress );
	writel( transfer_info->Descriptor[0].size, dmasizAddress );
	writel( dmadprstuff, dmadprAddress);

	// Set DMA mode
	dmamode_reg = 0;
	dmamode_reg |= (transfer_info->demandMode ? PLX_DEMAND : PLX_LOCBURS);
	dmamode_reg |= PLX_TARDY;
	dmamode_reg |= PLX_32BIT | PLX_DINT | PLX_PCIINT | PLX_SCATTER;

	if 
	(
		pdx[board_num].driverConfig.blockPoint 
		== SI_CONFIGDRIVER_TRANSFERPOINT
	)
	{
		for (i=0; i < iobuf->nr_pages; i++)
			transfer_info->Descriptor[i].localaddr = dspaddr;		

		pdx[board_num].readtransfer.local_addr = dspaddr;
		pdx[board_num].writetransfer.local_addr = dspaddr;

		dmamode_reg |= PLX_LOCINC;
	}
	
	writel(dmamode_reg, dmamodeAddress);

	SIprintk1
	((
		kModuleName "-SIPLX_doBlockDMA: "
		"dmamode_reg=0x%lx", 
		dmamode_reg
	));
		

	// Enable interrupts
	intcsr_reg = 
		readl
		(
			pdx[board_num].mem[PLX_OPREGS].base_addr + (PLX_INTCSR * 4)
		);
	intcsr_reg |= PLX_LIIE | PLX_PCIIE | interruptBit;
	
	writel
	(
		intcsr_reg, 
		pdx[board_num].mem[PLX_OPREGS].base_addr + (PLX_INTCSR * 4)
	);
	
	// Start DMA 
	writeb(enableBit, dmacsrAddress);
	writeb(enableBit | startBit, dmacsrAddress);

	SIprintk0((kModuleName "-SIPLX_doBlockDMA: Exiting\n"));
	
	return 0;		
}

////////////////////////////////////////////////////////////////////////////////
int SI_Alloc_Kiobuf(struct kiobuf **bufp, int nr)
{
	struct page **maplist;
	struct kiobuf *iobuf;
	int i;
	
	for(i = 0; i < nr; i++)
	{
		//from init_kiobuf() and alloc_kiovec() updated to kern 2.5
		iobuf = kmalloc(sizeof(struct kiobuf), GFP_KERNEL);
		if (!iobuf)
			return -ENOMEM;
		
		memset(iobuf, 0, sizeof(*iobuf));
		init_waitqueue_head(&iobuf->wait_queue);
		atomic_set(&iobuf->io_count, 0);
		
		maplist = (struct page**)
			kmalloc(KIO_STATIC_PAGES * sizeof(struct page**), GFP_KERNEL);
		if (!maplist)
		{
			kfree(iobuf);
			return -ENOMEM;
		}
		iobuf->maplist = maplist;
		iobuf->array_len = KIO_STATIC_PAGES;
		iobuf->initialized = 1;
	
		bufp[i] = iobuf;
	}
	return 1;
}

////////////////////////////////////////////////////////////////////////////////
void SI_Free_Kiovec(struct kiobuf **bufp, int nr)
{
	struct kiobuf *iobuf;
	int i;

	for (i = 0; i < nr; i++)
	{
		iobuf = bufp[i];
		
		//from free_kiovec and unmap_iobuf and kern 2.5
		if (iobuf->locked)
			unlock_kiovec(1, &iobuf);

		kfree(iobuf->maplist);
		
		iobuf->nr_pages = 0;
		iobuf->locked = 0;
		kfree(bufp[i]);
	}		
}

////////////////////////////////////////////////////////////////////////////////
void SI_unmap_kiobuf (struct kiobuf *iobuf) 
{
	int i;
	struct page *map;
	
	for (i = 0; i < iobuf->nr_pages; i++) {
		map = iobuf->maplist[i];
		if (map) {
			if (iobuf->locked)
				UnlockPage(map);

			atomic_dec(&map->count);
		}
	}
	
	iobuf->nr_pages = 0;
	iobuf->locked = 0;
}
