
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>


#define DllExport	__declspec( dllexport )

struct DataHeader
{
	UINT32 GEN;						//	generation
	UINT32	N;						//	N
	UINT32	M;						//	M
	UINT32	DATA_SIZE;				//	datasize
	UINT32	BLOCK_ADDR;				//	data block address
	UINT32 TYPE;					//	data type
};
const UINT32 HeaderSize = 6;

UINT32 gGeneration = 0;

enum eError
{
	eErr_LoadLibrary = 1,
	eErr_ObtainPointertoFunction,
	eErr_ObtainPointertoFile,
	eErr_Read,
	eErr_Write,
	eErr_DataSize
};

// Export Declarations for functions
// to load/unload sisamplib.dll manually.
DllExport INT32 WINAPI
loadSISamplibDll();

DllExport INT32 WINAPI
unloadSISamplibDll();


// Export Declarations for functions from this DLL.
DllExport INT32 WINAPI
VQ_addTest_LoadQuListFile
(
	INT32 boardID,
	char qulistfilepath[]
);


DllExport INT32 WINAPI
VQ_addTest_manageInputs
(
	INT32 boardID,
	UINT32 *inputHeaders,
	UINT32 numOfHeaders,
	float *inputValues,		// user must create the array of proper size before calling.
	UINT32 sizeOfValues,
	UINT32 *numHeadersWritten,
	UINT32 *numDataWritten
);


DllExport INT32 WINAPI
VQ_addTest_manageOutputs
(
	INT32 boardID,
	UINT32 *outputHeaders,
	UINT32 numOfHeaders,
	float *outputValues,	// user must create the array of proper size before calling.
	UINT32 sizeOfValues,
	UINT32 *numHeadersRead,
	UINT32 *numDataRead,
	UINT32 synctoGeneration
);


DllExport INT32 WINAPI
VQ_addTest_manageInputsAndOutputs
(
	INT32 boardID,
	UINT32 *inputHeaders,
	UINT32 numInputHeaders,
	float *inputValues,		// user must create the array of proper size before calling.
	UINT32 sizeInputValues,
	UINT32 *numHeadersWritten,
	UINT32 *numDataWritten,
	UINT32 *outputHeaders,
	UINT32 numOutputHeaders,
	float *outputValues,	// user must create the array of proper size before calling.
	UINT32 sizeOutputValues,
	UINT32 *numHeadersRead,
	UINT32 *numDataRead,
	UINT32 synctoGeneration
);


DllExport INT32 WINAPI
addTest_LoadCofffile
(
	INT32 boardID,
	char coffFileName[],
	UINT32 coffOptions
);

