library ieee;
use ieee.std_logic_1164.all;

entity GENERIC_TOP is
port
(
	iHardReset	: in std_logic;
	iClk		: in std_logic;

	-- external signals for DSP
	iXCSn		: in std_logic;
	iXRWn		: in std_logic;
	iXAddr		: in std_logic_vector(15 downto 0);
	ioXData		: inout std_logic_vector(31 downto 0);
	oXRDYn		: out std_logic;

	--out signals to be tied
	oMoreGnd	: out std_logic_vector(3 downto 0);
	oxintan	: out std_logic;
	oxintbn	: out std_logic

);
end GENERIC_TOP;

architecture structural of GENERIC_TOP is

--------------------------------------------------------------------------------
-- component declares
component IF_MEM 
port
(
	-- FPGA internal signals
	-- master signal
	iHardReset	: in std_logic; -- 0=run, 1=reset all flops
	iClk		: in std_logic;
	
	iXAddr	: in std_logic_vector(15 downto 0);
	ioData	: inout std_logic_vector(31 downto 0);
	-- signals from IF_MEM
	oRdyMEM	: out std_logic;
	-- signals going to IF_MEM
	iDecode_MEM0_RD	: in std_logic;
	iDecode_MEM0_WR	: in std_logic;
	iDecode_MEM1_RD	: in std_logic;
	iDecode_MEM1_WR	: in std_logic
	
);	
end component;

component IF_DSP 
port
(
	-- FPGA internal signals
	-- master signal
	iHardReset	: in std_logic; -- 0=run, 1=reset all flops
	iClk		: in std_logic;

	-- external signals for DSP
	iXCSn	: in std_logic;
	iXRWn	: in std_logic;
	iXAddr	: in std_logic_vector(15 downto 0);
	ioXData	: inout std_logic_vector(31 downto 0);
	oXRDYn	: out std_logic;

	ioData	: inout std_logic_vector(31 downto 0);
	-- signals from IF_MEM
	iRdyMEM	: in std_logic;
	-- signals going to IF_MEM
	oDecode_MEM0_RD	: out std_logic;
	oDecode_MEM0_WR	: out std_logic;
	oDecode_MEM1_RD	: out std_logic;
	oDecode_MEM1_WR	: out std_logic
);	
end component;

--------------------------------------------------------------------------------
-- signal declares
signal sDecode_MEM0_WR, sDecode_MEM0_RD : std_logic;
signal sDecode_MEM1_WR, sDecode_MEM1_RD : std_logic;
signal sRdyMEM : std_logic;

signal sioData : std_logic_vector(31 downto 0);


--signal sTemp : std_logic_vector(31 downto 0);

--------------------------------------------------------------------------------

begin

--------------------------------------------------------------------------------
-- debug

--sTemp(31 downto 19) <= (others => '0');
--sTemp(18 downto 0) <= soAddr;

--P_FlipFlop : process (iGPIO)
--begin
--	for cnt in 0 to 3 loop	
--		if iGPIO(cnt)'event and iGPIO(cnt) = '1' then
--			oGPIO(cnt) <= soGPIO(cnt);  
--		end if;
--	end loop;
--  
--end process;

--------------------------------------------------------------------------------
-- simple assignments

oMoreGnd <= (others => '0');
oxintan	<= '0';
oxintbn <= '0';
--------------------------------------------------------------------------------

U_IF_MEM : IF_MEM port map
(
	-- FPGA internal signals
	-- master signal
	iHardReset => iHardReset, -- 0=run, 1=reset all flops
	iClk => iClk,
	
	iXAddr => iXAddr,
	ioData => sioData,
	-- signals from IF_MEM
	oRdyMEM	=> sRdyMEM,
	-- signals going to IF_MEM
	iDecode_MEM0_RD	=> sDecode_MEM0_RD,
	iDecode_MEM0_WR	=> sDecode_MEM0_WR,
	iDecode_MEM1_RD	=> sDecode_MEM1_RD,
	iDecode_MEM1_WR	=> sDecode_MEM1_WR
);	

U_IF_DSP : IF_DSP port map
(
	-- FPGA internal signals
	-- master signal
	iHardReset => iHardReset, -- 0=run, 1=reset all flops
	iClk => iClk,

	-- external signals for DSP
	iXCSn => iXCSn,
	iXRWn => iXRWn,
	iXAddr => iXAddr,
	ioXData => ioXData,
	oXRDYn => oXRDYn,

	ioData => sioData,
	-- signals from IF_MEM
	iRdyMEM => sRdyMEM,
	-- signals going to IF_MEM
	oDecode_MEM0_RD	=> sDecode_MEM0_RD,
	oDecode_MEM0_WR	=> sDecode_MEM0_WR,
	oDecode_MEM1_RD	=> sDecode_MEM1_RD,
	oDecode_MEM1_WR	=> sDecode_MEM1_WR
);	

end structural;


