library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity IF_DSP is
port
(
	-- FPGA internal signals
	-- master signal
	iHardReset	: in std_logic; -- 0=run, 1=reset all flops
	iClk		: in std_logic;

	-- external signals for DSP
	iXCSn	: in std_logic;
	iXRWn	: in std_logic;
	iXAddr	: in std_logic_vector(15 downto 0);
	ioXData	: inout std_logic_vector(31 downto 0);
	oXRDYn	: out std_logic;

	ioData	: inout std_logic_vector(31 downto 0);
	-- signals from IF_MEM
	iRdyMEM	: in std_logic;
	-- signals going to IF_MEM
	oDecode_MEM0_RD	: out std_logic;
	oDecode_MEM0_WR	: out std_logic;
	oDecode_MEM1_RD	: out std_logic;
	oDecode_MEM1_WR	: out std_logic
);	
end IF_DSP;
		  
architecture behavioral of IF_DSP is

signal siXRWn	: std_logic;
signal sDSPWrite, sDSPRead : std_logic;

signal sDecode_MEM0, sDecode_MEM0r : std_logic;
signal sDecode_MEM1, sDecode_MEM1r	: std_logic;

begin

--------------------------------------------------------------------------------
-- template

P_RW: process (iHardReset, iClk)
begin
	if iHardReset = '1' then
		siXRWn <= '0';

	elsif iClk'event and iClk = '1' then
		siXRWn <= iXRWn;
	end if;
end process;

P_DriveData : process(iHardReset, iClk)
begin
	if iHardReset = '1' then
		ioXData	<= (others => 'Z');
		ioData		<= (others => 'Z');

	elsif iClk'event and iClk = '1' then

		ioXData 	<= (others => 'Z');
		if sDSPRead = '1' then
			ioXData	<= ioData;
		end if;

		ioData <= (others => 'Z');
		if sDSPWrite = '1' then
			ioData	<= ioXData;
		end if;

	end if;

end process;	
--------------------------------------------------------------------------------
-- simple signals

--On the SIC6711 board, the bottom range uses XRdy (0x80380000)
--and the top range does not use XRdy(0x803A0000)
oXRDYn <= iRdyMEM when (iXAddr(15) = '0')
	else '0';

--Read Signals
sDSPRead <= not(iXCSn) and siXRWn;

oDecode_MEM0_RD <= sDecode_MEM0r and sDSPRead;
oDecode_MEM1_RD	<= sDecode_MEM1r and sDSPRead;

--Write Signals
sDSPWrite <= not(iXCSn) and not(siXRWn);

oDecode_MEM0_WR <= sDecode_MEM0r and sDSPWrite;
oDecode_MEM1_WR <= sDecode_MEM1r and sDSPWrite;

--------------------------------------------------------------------------------


P_DSPDecoder	: process (iHardReset, iClk)
begin
	if iHardReset = '1' then

		sDecode_MEM0r <= '0';
		sDecode_MEM1r <= '0';

	elsif iClk'event and iClk = '1' then

		sDecode_MEM0r <= sDecode_MEM0;
		sDecode_MEM1r <= sDecode_MEM1;

	end if;

end process;


--------------------------------------------------------------------------------
-- DSP

P_DSPDecode : process (iXAddr(3), iXCSn, iXRWn)
begin
	sDecode_MEM0 <= '0';
	sDecode_MEM1 <= '0';

	case iXAddr(3) is
		when '0' =>
			sDecode_MEM0 <= '1';
		when '1' =>
			sDecode_MEM1 <= '1';

		when others=>
	end case;

end process;
	

end behavioral;



