library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity IF_MEM is
port
(
	-- FPGA internal signals
	-- master signal
	iHardReset	: in std_logic; -- 0=run, 1=reset all flops
	iClk		: in std_logic;
	
	iXAddr	: in std_logic_vector(15 downto 0);
	ioData	: inout std_logic_vector(31 downto 0);
	-- signals from IF_MEM
	oRdyMEM	: out std_logic;
	-- signals going to IF_MEM
	iDecode_MEM0_RD	: in std_logic;
	iDecode_MEM0_WR	: in std_logic;
	iDecode_MEM1_RD	: in std_logic;
	iDecode_MEM1_WR	: in std_logic
);	
end IF_MEM;
		  
architecture behavioral of IF_MEM is

type sReg is array(7 downto 0) of std_logic_vector(31 downto 0);
signal sMEM0, sMEM1	: sReg; 

signal sCount : std_logic_vector(2 downto 0);
signal sioData0 : std_logic_vector(31 downto 0);
signal sioData1 : std_logic_vector(31 downto 0);
begin

--------------------------------------------------------------------------------
-- constant signals

ioData <= sioData0 when(iDecode_MEM0_RD = '1')
	else sioData1 when(iDecode_MEM1_RD = '1')
	else (others => 'Z');

--------------------------------------------------------------------------------

-- template
P_X : process (iHardReset, iClk)
begin
	if iHardReset = '1' then
	elsif iClk'event and iClk = '1' then
	end if;
end process;
	
--------------------------------------------------------------------------------
--MEM 0

P_MEM0Read: process (iDecode_MEM0_RD, iXAddr(2 downto 0))
begin
	if iDecode_MEM0_RD = '1' then
			case iXAddr(2 downto 0) is
				when "000" =>
					sioData0 <= sMEM0(0);
				when "001" =>
					sioData0 <= sMEM0(1);
				when "010" =>
					sioData0 <= sMEM0(2);
				when "011" =>
					sioData0 <= sMEM0(3);
				when "100" =>
					sioData0 <= sMEM0(4);
				when "101" =>
					sioData0 <= sMEM0(5);
				when "110" =>
					sioData0 <= sMEM0(6);
				when "111" =>
					sioData0 <= sMEM0(7);

				when others =>
			end case;
		
	end if;
end process;

P_MEM0Write: process (iHardReset, iClk)
begin
	if iHardReset = '1' then
		for cnt in 0 to 7 loop
			sMEM0(cnt) <= (others => '0');
		end loop;			

	elsif iClk'event and iClk = '1' then
		if iDecode_MEM0_WR = '1' then
			case iXAddr(2 downto 0) is
				when "000" =>
					sMEM0(0) <= ioData;
				when "001" =>
					sMEM0(1) <= ioData;
				when "010" =>
					sMEM0(2) <= ioData;
				when "011" =>
					sMEM0(3) <= ioData;
				when "100" =>
					sMEM0(4) <= ioData;
				when "101" =>
					sMEM0(5) <= ioData;
				when "110" =>
					sMEM0(6) <= ioData;
				when "111" =>
					sMEM0(7) <= ioData;

				when others =>
			end case;
		end if;
	end if;

end process;

--------------------------------------------------------------------------------
--MEM 1

P_MEM1Read: process (iDecode_MEM1_RD, iXAddr(2 downto 0))
begin
	if iDecode_MEM1_RD = '1' then
			case iXAddr(2 downto 0) is
				when "000" =>
					sioData1 <= sMEM1(0);
				when "001" =>
					sioData1 <= sMEM1(1);
				when "010" =>
					sioData1 <= sMEM1(2);
				when "011" =>
					sioData1 <= sMEM1(3);
				when "100" =>
					sioData1 <= sMEM1(4);
				when "101" =>
					sioData1 <= sMEM1(5);
				when "110" =>
					sioData1 <= sMEM1(6);
				when "111" =>
					sioData1 <= sMEM1(7);

				when others =>
			end case;
		
	end if;
end process;

P_MEM1Write: process (iHardReset, iClk)
begin
	if iHardReset = '1' then
		for cnt in 0 to 7 loop
			sMEM1(cnt) <= (others => '0');
		end loop;			

	elsif iClk'event and iClk = '1' then
		if iDecode_MEM1_WR = '1' then
			case iXAddr(2 downto 0) is
				when "000" =>
					sMEM1(0) <= ioData;
				when "001" =>
					sMEM1(1) <= ioData;
				when "010" =>
					sMEM1(2) <= ioData;
				when "011" =>
					sMEM1(3) <= ioData;
				when "100" =>
					sMEM1(4) <= ioData;
				when "101" =>
					sMEM1(5) <= ioData;
				when "110" =>
					sMEM1(6) <= ioData;
				when "111" =>
					sMEM1(7) <= ioData;

				when others =>
			end case;
		end if;
	end if;

end process;

P_RDY: process (iHardReset, iClk)
begin
	if iHardReset = '1' then
		sCount <= (others => '0');
		oRdyMEM <= '1';
	
	elsif iClk'event and iClk = '1' then
		oRdyMEM <= '1';
		if iDecode_MEM1_RD = '1' or iDecode_MEM1_WR = '1' then
			sCount <= sCount + 1;
			if sCount = "110" then
				oRdyMEM <= '0';
				sCount <= "110";
			end if;
		else
			sCount <= (others => '0');
		end if;		
	end if;
end process;

end behavioral;