
LIBRARY  ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all;

ENTITY testbench IS
END testbench;

ARCHITECTURE testbench_arch OF testbench IS

constant kClk 		: time :=  24 ns;
constant kClkADC0 	: time := 326 ns;
constant kClkADC1 	: time := 326 ns;
constant kClkADC2 	: time := 326 ns;
constant kClkDac 	: time := 652 ns;

constant kDSPClk2Out : time := 9 ns;
constant kDSPSetupTime : time := kClk - 8 ns; -- XRDY must be on OFD!
constant kADCClk2Out : time := 100 ns;

component GENERIC_TOP port
(
	iHardReset	: in std_logic;
	iClk		: in std_logic;

	-- external signals for DSP
	iXCSn		: in std_logic;
	iXRWn		: in std_logic;
	iXAddr		: in std_logic_vector(15 downto 0);
	ioXData		: inout std_logic_vector(31 downto 0);
	oXRDYn		: out std_logic;

	--out signals to be tied
	oMoreGnd	: out std_logic_vector(3 downto 0);
	oxintan	: out std_logic;
	oxintbn	: out std_logic
);
end component;

signal iHardReset : std_logic;
signal iClk : std_logic;
signal iXCSn : std_logic;
signal iXRWn : std_logic;
signal iXAddr : std_logic_vector(15 downto 0);
signal ioXData : std_logic_vector(31 downto 0);
signal oXRDYn : std_logic;
signal oMoreGnd : std_logic_vector(3 downto 0);
signal sINT : std_logic_vector(1 downto 0);



begin


UUT : GENERIC_TOP port map
(
	iHardReset => iHardReset, 
	iClk => iClk,
	iXCSn => iXCSn, 
	iXRWn => iXRWn, 
	iXAddr => iXAddr, 
	ioXData => ioXData, 
	oXRDYn => oXRDYn, 
	oMoreGnd => oMoreGnd,
	oxintan => sINT(0),
	oxintbn	=> sINT(1)
);

--------------------------------------------------------------------------------

PROCESS -- clock process for iClk,
BEGIN
	iClk <= '1';
	WAIT FOR kClk / 2;
	iClk <= '0';
	WAIT FOR kClk / 2;
END PROCESS;

--------------------------------------------------------------------------------


--------------------------------------------------------------------------------
-- simulate memory

--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------

-- main

process

procedure Proc_Reset( x : in std_logic ) is
begin
	iHardReset <= '1';
	iXCSn <= '1';
	iXRWn <= '1';
 	iXAddr <= (others => '0');
 	ioXData <= (others => 'Z');



	wait for kClk * 2;

	iHardReset <= '0';
	wait for kClk * 2;
end;

procedure Proc_DSPWrite
(
	vAddr : in std_logic_vector(15 downto 0); 
	vData : in std_logic_vector(31 downto 0)
) is begin
	iXAddr <= vAddr after kDSPClk2Out;
	ioXData <= vData after kDSPClk2Out;
	iXRWn <= '0' after kDSPClk2Out;
	wait for kClk;

	iXCSn <= '0' after kDSPClk2Out;
	wait for kClk;
	wait for kClk - kDSPSetupTime;
	while oXRDYn = '1' loop
		wait for kClk;
	end loop;
	wait for kDSPSetupTime;
	
	iXCSn <= '1' after kDSPClk2Out;
	iXRWn <= '1' after kDSPClk2Out;
 	ioXData <= (others => 'Z') after kDSPClk2Out;
	wait for kClk;
end;

procedure Proc_DSPRead
(
	vAddr : in std_logic_vector(15 downto 0); 
	vData : out std_logic_vector(31 downto 0) 
)is 
begin
	iXAddr <= vAddr after kDSPClk2Out;
	wait for kClk;

	iXCSn <= '0' after kDSPClk2Out;
	wait for kClk;
	wait for kClk - kDSPSetupTime;
	while oXRDYn = '1' loop
		wait for kClk;
	end loop;
	vData := ioXData;
	wait for kDSPSetupTime;
	
	-- check for valid data here
	iXCSn <= '1' after kDSPClk2Out;
	wait for kClk;
end;


variable vAddr : std_logic_vector(15 downto 0);
variable vData, vData1, vData2 : std_logic_vector(31 downto 0);
begin
	sINT(0) <= '0';
	sINT(1) <= '0';
	Proc_Reset('0');
	vAddr := X"0000";
	vData := X"00000000";

wait for kClk * 2;
	Proc_DSPWrite(X"8003", X"010C0FFF");
wait for kClk * 2;
	Proc_DSPRead(X"8003", vData);
wait for kClk * 2;
	Proc_DSPWrite(X"0008", X"10000CCC");
wait for kClk * 2;
	Proc_DSPRead(X"0008", vData);
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------

	wait for kClk * 20;

	ASSERT (FALSE) REPORT
		"Simulation done."
		SEVERITY FAILURE;
	

end process;



end testbench_arch;

CONFIGURATION MYER_TOP_cfg OF testbench IS
	FOR testbench_arch
	END FOR;
END MYER_TOP_cfg;
